package com.mythicmetals.item;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.misc.RegistryHelper;
import io.wispforest.owo.util.TagInjector;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1792.class_1793;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ItemSet {
    private final class_1792 ingotItem;
    private class_1792 rawOreItem = null;
    private class_1792 nuggetItem = null;
    private class_1792 dustItem = null;
    private boolean requiresBlasting = false;
    // Used for smelting recipes during datagen
    private final float xp;

    private static class_1792.class_1793 createSettings(Consumer<class_1792.class_1793> settingsProcessor) {
        final var settings = new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(0);
        settingsProcessor.accept(settings);
        return settings;
    }

    public ItemSet(float xp) {
        this(false, false, xp, settings -> {
        });
    }

    public ItemSet(float xp, boolean requiresBlasting) {
        this(false, requiresBlasting, xp, settings -> {
        });
    }

    public ItemSet(boolean isAlloy) {
        this(isAlloy, true, 0.1f, settings -> {
        });
    }

    public ItemSet(boolean isAlloy, float xp) {
        this(isAlloy, false, xp, settings -> {
        });
    }

    public ItemSet(boolean isAlloy, float xp, boolean requiresBlasting) {
        this(isAlloy, requiresBlasting, xp, settings -> {
        });
    }

    public ItemSet(boolean isAlloy, boolean requiresBlasting, Consumer<class_1792.class_1793> settingsConsumer) {
        this(isAlloy, requiresBlasting, 0.1f, settingsConsumer);
    }

    public ItemSet(boolean isAlloy, boolean requiresBlasting, float xp, Consumer<class_1792.class_1793> settingsConsumer) {
        this.ingotItem = makeItem(createSettings(settingsConsumer));
        if (!isAlloy) {
            this.rawOreItem = makeItem(createSettings(settingsConsumer));
        }
        if (MythicMetals.CONFIG.enableNuggets()) {
            this.nuggetItem = makeItem(createSettings(settingsConsumer));
        }
        if (MythicMetals.CONFIG.enableDusts()) {
            this.dustItem = makeItem(createSettings(settingsConsumer));
        }
        this.xp = xp;
        this.requiresBlasting = requiresBlasting;
    }

    public void register(String name) {
        class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name + "_ingot"), ingotItem);
        if (rawOreItem != null) {
            class_2378.method_10230(class_7923.field_41178, RegistryHelper.id("raw_" + name), rawOreItem);
        }
        if (nuggetItem != null) {
            class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name + "_nugget"), nuggetItem);
            // Conditionally add nuggets to nuggets tag
            TagInjector.inject(class_7923.field_41178, class_2960.method_60655("c", "nuggets"), nuggetItem);
        }
        if (dustItem != null) {
            class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name + "_dust"), dustItem);
        }
    }

    public void register(String name, boolean imStarPlatinum) {
        if (imStarPlatinum) {
            class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name), ingotItem);
            if (nuggetItem != null) {
                class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name + "_nugget"), nuggetItem);
            }
            if (dustItem != null) {
                class_2378.method_10230(class_7923.field_41178, RegistryHelper.id(name + "_dust"), dustItem);
            }
        } else {
            register(name);
        }

    }

    protected class_1792 makeItem(class_1792.class_1793 settings) {
        return new class_1792(settings);
    }

    public class_1792 getRawOre() {
        return rawOreItem;
    }

    public class_1792 getIngot() {
        return ingotItem;
    }

    public class_1792 getNugget() {
        return nuggetItem;
    }

    public class_1792 getDust() {
        return dustItem;
    }

    public boolean requiresBlasting() {
        return requiresBlasting;
    }

    public float getXp() {
        return this.xp > 0 ? this.xp : 0.0f;
    }
}
