package com.mythicmetals.item.tools;

import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

/**
 * Used to handle Auto Repair behavior regarding more gracefully
 */
public interface AutoRepairable extends FabricItem {

    // Don't interrupt mining if durability is repaired
    // Might affect mending as a side effect
    @Override
    default boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7919() != newStack.method_7919();
    }

    // Don't update the item in hand if durability is repaired
    // Might affect mending as a side effect
    @Override
    default boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return oldStack.method_7919() == newStack.method_7919();
    }
}
