package com.mythicmetals.item.tools;

import com.mythicmetals.misc.BlockBreaker;
import com.mythicmetals.misc.MythicParticleSystem;
import com.mythicmetals.registry.RegisterCriteria;
import io.wispforest.owo.ops.WorldOps;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.item.*;

public class BanglumPick extends class_1810 {

    public BanglumPick(class_1832 material, class_1793 settings) {
        super(material, settings);
    }

    /**
     * Method for the legendary banglum pickaxe breaking ability.
     * When the tool is used on a block, it breaks a bunch of blocks in a set radius.
     */
    @Override
    public class_1269 method_7884(class_1838 context) {
        boolean shouldPass = false;
        var world = context.method_8045();
        var player = context.method_8036();

        if (player != null && !isCoolingDown(player, context.method_8041()) && !world.method_8608()) {

            var iterator = BlockBreaker.findBlocks(context, 5);
            for (class_2338 blockPos : iterator) {
                if (BlockBreaker.isProtected(world, blockPos, player.method_7334(), player)) {
                    continue;
                }
                if (method_58405(context.method_8041(), world.method_8320(blockPos))) {
                    WorldOps.breakBlockWithItem(world, blockPos, context.method_8041(), player);
                    context.method_8041().method_7970(2, player, class_1304.field_6173);
                    shouldPass = true;
                }
            }

        }

        if (shouldPass) {
            var pos = context.method_8037();
            var facing = context.method_8038().method_10153();
            var pos2 = context.method_8037().method_10079(facing, 5);

            MythicParticleSystem.EXPLOSION_TRAIL.spawn(world, class_243.method_24954(pos), class_243.method_24954(pos2));
            WorldOps.playSound(world, pos, class_3417.field_15152.comp_349(), class_3419.field_15248);

            RegisterCriteria.USED_BLAST_MINING.trigger((class_3222) player);
            player.method_7357().method_7906(this, 100);
            return class_1269.field_5812;
        }

        return class_1269.field_5814;
    }

    public static boolean isCoolingDown(class_1309 entity, class_1799 stack) {
        if (entity != null && entity.method_31747()) {
            return ((class_1657) entity).method_7357().method_7904(stack.method_7909());
        }
        return false;
    }
}
