package com.mythicmetals.item.tools;

import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.misc.CarmotBellDamageSource;
import com.mythicmetals.misc.MythicParticleSystem;
import com.mythicmetals.registry.RegisterSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_3483;
import net.minecraft.item.*;
import net.minecraft.util.*;
import java.util.List;

public class CarmotBellItem extends class_1747 {

    public static final double RANGE = 6.0;

    public CarmotBellItem(class_1793 settings) {
        super(MythicBlocks.CARMOT_BELL_BLOCK, settings);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        var stack = user.method_5998(hand);
        var entities = world.method_8335(user, class_238.method_30048(user.method_19538(), RANGE * 2, RANGE, RANGE * 2));
        entities.forEach(entity -> {
            if (entity instanceof class_1309 livingEntity) {
                if (livingEntity.method_5864().method_20210(class_3483.field_46232)) {
                    var damageSource = CarmotBellDamageSource.of(world, user);
                    entity.method_5643(damageSource, Math.max(10.0f, livingEntity.method_6032() * 0.1f));
                    MythicParticleSystem.HEALING_DAMAGE.spawn(world, livingEntity.method_19538());
                } else {
                    livingEntity.method_6025(Math.max(10.0f, livingEntity.method_6063() * 0.1f));
                    MythicParticleSystem.HEALING_HEARTS.spawn(world, livingEntity.method_19538());
                }
                stack.method_7970(1, user, class_1657.method_56079(hand));
            }
        });
        user.method_6025(Math.max(10.0f, user.method_6063() * 0.1f));
        stack.method_7970(1, user, class_1657.method_56079(hand));
        MythicParticleSystem.HEALING_AREA.spawn(world, user.method_19538(), RANGE);
        MythicParticleSystem.HEALING_HEARTS.spawn(world, user.method_19538());
        user.method_7357().method_7906(this, 480);
        world.method_45447(user, user.method_24515(), RegisterSounds.CARMOT_BELL_RING, class_3419.field_15248);
        return class_1271.method_22427(stack);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        return class_1269.field_5811;
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        tooltip.add(class_2561.method_43471("tooltip.carmot_bell.info1"));
        tooltip.add(class_2561.method_43471("tooltip.carmot_bell.info2"));
    }
}
