package com.mythicmetals.item.tools;

import com.mythicmetals.component.GoldFoldedComponent;
import com.mythicmetals.component.MythicDataComponents;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class MidasGoldSword extends class_1829 {
    public MidasGoldSword(class_1832 material, class_1793 settings) {
        super(material, settings);
    }

    @Override
    public void method_7860(class_1799 stack) {
        // TODO - Surely there is a better way to do dynamic attributes, right? Right??
        //  This is a lot of effort for the correct green tooltip... Thanks Mojang
        var currentAttributes = stack.method_57824(class_9334.field_49636);
        int goldCount = stack.method_57825(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(0)).goldFolded();
        var originalDamage = new AtomicReference<>(0.0);
        stack.method_58658().method_57829(class_9334.field_49636).comp_2393().forEach(entry -> {
            if (entry.comp_2396().comp_2447().equals(field_8006)) {
                originalDamage.set(entry.comp_2396().comp_2449());
            }
        });
        double goldDmgBonus = computeBonusDamage(goldCount);

        var speed = new AtomicReference<>(0.0);
        // Copy attack speed over. We want to re-build, not add anything
        currentAttributes.comp_2393().forEach(entry -> {
            if (entry.comp_2395().equals(class_5134.field_23723)) {
                speed.set(entry.comp_2396().comp_2449());
            }
        });

        if (goldDmgBonus > 0) {
            var changedComponent = class_9285.method_57480()
                .method_57487(
                    class_5134.field_23721,
                    new class_1322(field_8006,
                        originalDamage.get() + goldDmgBonus,
                        class_1322.class_1323.field_6328
                    ),
                    class_9274.field_49217
                )
                .method_57487(
                    class_5134.field_23723,
                    new class_1322(field_8001, speed.get(), class_1322.class_1323.field_6328),
                    class_9274.field_49217
                )
                .method_57486();
            stack.method_57379(class_9334.field_49636, changedComponent);
        }
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> lines, class_1836 type) {
        if (stack.method_57826(MythicDataComponents.GOLD_FOLDED)) {
            stack.method_57824(MythicDataComponents.GOLD_FOLDED).method_57409(context, lines::add, type);
        }
    }

    public int computeBonusDamage(int goldCount) {
        int bonus = class_3532.method_15340(class_3532.method_15375((float) goldCount / 64), 0, 6);
        if (goldCount >= 1280) {
            bonus += 1;
        }
        return bonus;
    }

    public static float countGold(int goldCount) {
        if (goldCount >= 1280) return 1.0f;
        return switch (goldCount / 64) {
            case 1 -> 0.1f;
            case 2, 3 -> 0.2f;
            case 4 -> 0.3f;
            case 5, 6, 7, 8, 9 -> 0.4f;
            case 10, 11 -> 0.5f;
            case 12, 13 -> 0.6f;
            case 14, 15 -> 0.7f;
            case 16, 17 -> 0.8f;
            case 18 -> 0.9f;
            case 19 -> 1.0f;
            default -> 0.0f;
        };
    }

    /**
     * Calculates a level from intervals of 64.
     * Used for appending specific text to a Midas Gold Sword tooltip
     *
     * @param goldCount The amount of gold that is currently applied on this stack
     * @return amount of gold divided by 64, or 0 if less than 64 gold
     */
    public static int calculateSwordLevel(int goldCount) {
        if (goldCount < 64) return 0;
        return (goldCount / 64);
    }

    public enum Type {
        REGULAR,
        GILDED,
        ROYAL;

        @Nullable
        public static MidasGoldSword.Type getSwordType(class_1799 stack) {
            return getSwordType(stack.method_7909());
        }

        @Nullable
        public static MidasGoldSword.Type getSwordType(class_1792 item) {

            if (item.equals(MythicTools.MIDAS_GOLD_SWORD)) {
                return REGULAR;
            }
            if (item.equals(MythicTools.GILDED_MIDAS_GOLD_SWORD)) {
                return GILDED;
            }
            if (item.equals(MythicTools.ROYAL_MIDAS_GOLD_SWORD)) {
                return ROYAL;
            }
            return null;
        }

        public static boolean isOf(class_1799 stack, Type type) {
            var comparedType = getSwordType(stack);
            if (comparedType != null) {
                return comparedType.equals(type);
            }
            return false;
        }
    }
}
