package com.mythicmetals.item.tools;

import com.google.common.base.Suppliers;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.MythicItems;
import java.util.function.Supplier;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;

public enum MythicToolMaterials implements class_1832 {
    ADAMANTITE(4, 1024, 7.0F, 5F, 16, () -> class_1856.method_8091(MythicItems.ADAMANTITE.getIngot())),
    AEGIS_RED(4, 2170, 8.0F, 6.0F, 25, () -> class_1856.method_8091(MythicItems.PALLADIUM.getIngot())),
    AEGIS_WHITE(4, 2070, 10.0F, 5.0F, 25, () -> class_1856.method_8091(MythicItems.HALLOWED.getIngot())),
    AQUARIUM(2, 455, 6.5F, 2.0F, 12, () -> class_1856.method_8091(MythicItems.AQUARIUM.getIngot())),
    BANGLUM(2, 260, 11.0F, 2.0F, 1, () -> class_1856.method_8091(MythicItems.BANGLUM.getIngot())),
    BRONZE(2, 354, 5.5F, 2.5F, 14, () -> class_1856.method_8091(MythicItems.BRONZE.getIngot())),
    CARMOT(3, 1130, 11.5F, 3.0F, 42, () -> class_1856.method_8091(MythicItems.CARMOT.getIngot())),
    CARMOT_STAFF(3, 1230, 11.5F, 2.0F, 40, () -> class_1856.method_8091(MythicItems.CARMOT.getIngot())),
    CELESTIUM(5, 2470, 25.0F, 6.0F, 26, () -> class_1856.method_8091(MythicItems.CELESTIUM.getIngot())),
    COPPER(1, 187, 5.0F, 1.5F, 8, () -> class_1856.method_8091(class_1802.field_27022)),
    DURASTEEL(3, 820, 7.1F, 3.5F, 12, () -> class_1856.method_8091(MythicItems.DURASTEEL.getIngot())),
    GILDED_MIDAS_GOLD(3, 999, 13.0F, 4.0F, 30, () -> class_1856.method_8091(MythicBlocks.MIDAS_GOLD.getStorageBlock().method_8389())),
    HALLOWED(4, 1984, 12.0F, 5.0F, 20, () -> class_1856.method_8091(MythicItems.HALLOWED.getIngot())),
    KYBER(3, 889, 7.0F, 2.5F, 20, () -> class_1856.method_8091(MythicItems.KYBER.getIngot())),
    LEGENDARY_BANGLUM(3, 1040, 12.0F, 4.0F, 2, () -> class_1856.method_8091(MythicItems.BANGLUM.getIngot())),
    METALLURGIUM(5, 3000, 15.0F, 8.0F, 30, () -> class_1856.method_8091(MythicItems.METALLURGIUM.getIngot())),
    MIDAS_GOLD(3, 300, 13.0F, 3.0F, 30, () -> class_1856.method_8091(MythicItems.MIDAS_GOLD.getIngot())),
    MYTHRIL(4, 1564, 14.3F, 3.0F, 22, () -> class_1856.method_8091(MythicItems.MYTHRIL.getIngot())),
    MYTHRIL_DRILL(4, 1764, 27.4F, 3.0F, 20, () -> class_1856.method_8091(MythicItems.MYTHRIL.getIngot())),
    ORICHALCUM(4, 2048, 6.0F, 4.0F, 16, () -> class_1856.method_8091(MythicItems.ORICHALCUM.getIngot())),
    OSMIUM(3, 664, 7.0F, 3.0F, 13, () -> class_1856.method_8091(MythicItems.OSMIUM.getIngot())),
    PALLADIUM(4, 1234, 8.0F, 3.5F, 16, () -> class_1856.method_8091(MythicItems.PALLADIUM.getIngot())),
    PROMETHEUM(3, 1472, 6.0F, 4.0F, 15, () -> class_1856.method_8091(MythicItems.PROMETHEUM.getIngot())),
    QUADRILLUM(2, 321, 6.0F, 2.7F, 8, () -> class_1856.method_8091(MythicItems.QUADRILLUM.getIngot())),
    RUNITE(3, 1337, 8.9F, 3.3F, 17, () -> class_1856.method_8091(MythicItems.RUNITE.getIngot())),
    ROYAL_MIDAS_GOLD(3, 2147, 21.0F, 5.0F, 35, () -> class_1856.method_8091(MythicBlocks.MIDAS_GOLD.getStorageBlock().method_8389())),
    STAR_PLATINUM(4, 1300, 9.0F, 4.0F, 18, () -> class_1856.method_8091(MythicItems.STAR_PLATINUM.getIngot())),
    STEEL(3, 700, 6.5F, 3.0F, 11, () -> class_1856.method_8091(MythicItems.STEEL.getIngot())),
    STORMYX(3, 1305, 8.5F, 3.5F, 20, () -> class_1856.method_8091(MythicItems.STORMYX.getIngot())),
    TIDESINGER(3, 1233, 9.0F, 4.0F, 18, () -> class_1856.method_8091(MythicItems.AQUARIUM.getIngot()));

    private final int miningLevel;
    private final int itemDurability;
    private final float miningSpeedMultiplier;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<class_1856> repairIngredient;

    MythicToolMaterials(int miningLevel, int itemDurability, float miningSpeedMultiplier, float attackDamage, int enchantability, Supplier<class_1856> repairIngredient) {
        this.miningLevel = miningLevel;
        this.itemDurability = itemDurability;
        this.miningSpeedMultiplier = miningSpeedMultiplier;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    @Override
    public int method_8025() {
        return this.itemDurability;
    }

    @Override
    public float method_8027() {
        return this.miningSpeedMultiplier;
    }

    @Override
    public float method_8028() {
        return this.attackDamage;
    }

    @Override
    public class_6862<class_2248> method_58419() {
        return switch (this.miningLevel) {
            case 1 -> class_3481.field_49928;
            case 2 -> class_3481.field_49927;
            case 3 -> class_3481.field_49926;
            case 4 -> class_3481.field_49925;
            case 5 -> MythicTags.INCORRECT_FOR_UNOBTAINIUM_ALLOY_TOOLS;
            default -> throw new IllegalStateException("Unexpected value: " + this.miningLevel);
        };
    }

    @Override
    public int method_8026() {
        return this.enchantability;
    }

    @Override
    public class_1856 method_8023() {
        return this.repairIngredient.get();
    }
}
