package com.mythicmetals.item.tools;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.component.*;
import com.mythicmetals.item.*;
import com.mythicmetals.item.tools.carmot_staff.CarmotStaffItem;
import com.mythicmetals.misc.RegistryHelper;
import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import io.wispforest.owo.registration.reflect.SimpleFieldProcessingSubject;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1808;
import net.minecraft.class_1814;
import net.minecraft.class_1829;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7102;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.entity.*;
import net.minecraft.item.*;
import net.minecraft.registry.*;
import net.minecraft.util.*;
import java.lang.reflect.Field;
import java.util.*;

import static com.mythicmetals.item.tools.ToolSet.createAttributeModifiers;

@SuppressWarnings("unused")
public class MythicTools implements SimpleFieldProcessingSubject<ToolSet> {
    public static final Map<String, ToolSet> TOOL_MAP = new HashMap<>();
    // Arrays for weapon/tool damage: sword, axe, pickaxe, shovel, and hoe
    public static final int[] DEFAULT_DAMAGE = new int[]{3, 5, 2, 1, 0};
    // Arrays for weapon/tool attack speed: sword, axe, pickaxe, shovel and hoe
    public static final float[] SLOWEST_ATTACK_SPEED = new float[]{1.5F, 0.8f, 1.1f, 1.0f, 0.9f}; // -0.1 to all
    public static final float[] SLOWER_ATTACK_SPEED = new float[]{1.5f, 0.9f, 1.1f, 1.0f, 0.9f}; // -0.1 except axes
    public static final float[] DEFAULT_ATTACK_SPEED = new float[]{1.6f, 0.9f, 1.2f, 1.1f, 1.0f};
    public static final float[] BETTER_AXE_ATTACK_SPEED = new float[]{1.6f, 1.0f, 1.2f, 1.1f, 1.0f}; // +0.1 on axes
    public static final float[] FASTER_ATTACK_SPEED = new float[]{1.8f, 1.1f, 1.3f, 1.2f, 1.2f}; // +0.1-0.2 to all
    public static final float[] HIGHEST_ATTACK_SPEED = new float[]{2.0f, 1.2f, 1.4f, 1.3f, 1.4f}; // + 0.3-0.4 to all

    public static final ToolSet ADAMANTITE = new ToolSet(MythicToolMaterials.ADAMANTITE, DEFAULT_DAMAGE, BETTER_AXE_ATTACK_SPEED);
    public static final ToolSet AQUARIUM = new AquariumToolSet(MythicToolMaterials.AQUARIUM, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet BANGLUM = new ToolSet(MythicToolMaterials.BANGLUM, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final class_1792 BANGLUM_TNT_MINECART = new class_1808(MythicMetals.BANGLUM_TNT, new class_1792.class_1793().group(MythicMetals.TABBED_GROUP));
    public static final class_1792 PALLADIUM_MINECART = new class_1808(MythicMetals.PALLADIUM_MINECART, new class_1792.class_1793().group(MythicMetals.TABBED_GROUP)) {
        @Override
        public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
            super.method_7851(stack, context, tooltip, type);
            tooltip.add(class_2561.method_43471("item.mythicmetals.palladium_minecart.description").method_54663(UsefulSingletonForColorUtil.MetalColors.PALLADIUM.rgb()));
        }
    };
    public static final ToolSet BRONZE = new ToolSet(MythicToolMaterials.BRONZE, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet CARMOT = new ToolSet(MythicToolMaterials.CARMOT, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet CELESTIUM = new ToolSet(MythicToolMaterials.CELESTIUM, DEFAULT_DAMAGE, HIGHEST_ATTACK_SPEED, settings -> settings.method_7894(class_1814.field_8903));
    public static final ToolSet COPPER = new ToolSet(MythicToolMaterials.COPPER, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet DURASTEEL = new ToolSet(MythicToolMaterials.DURASTEEL, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet HALLOWED = new ToolSet(MythicToolMaterials.HALLOWED, DEFAULT_DAMAGE, BETTER_AXE_ATTACK_SPEED, settings -> settings.method_7894(class_1814.field_8907));
    public static final ToolSet KYBER = new ToolSet(MythicToolMaterials.KYBER, DEFAULT_DAMAGE, BETTER_AXE_ATTACK_SPEED);
    public static final ToolSet LEGENDARY_BANGLUM = new BanglumToolSet(MythicToolMaterials.LEGENDARY_BANGLUM, DEFAULT_DAMAGE, SLOWER_ATTACK_SPEED, settings -> settings.method_7894(class_1814.field_8907));
    public static final ToolSet METALLURGIUM = new ToolSet(MythicToolMaterials.METALLURGIUM, DEFAULT_DAMAGE, BETTER_AXE_ATTACK_SPEED, settings -> settings.method_24359().method_7894(class_1814.field_8903));
    public static final ToolSet MYTHRIL = new ToolSet(MythicToolMaterials.MYTHRIL, DEFAULT_DAMAGE, FASTER_ATTACK_SPEED);
    public static final ToolSet ORICHALCUM = new ToolSet(MythicToolMaterials.ORICHALCUM, DEFAULT_DAMAGE, SLOWER_ATTACK_SPEED);
    public static final ToolSet OSMIUM = new ToolSet(MythicToolMaterials.OSMIUM, DEFAULT_DAMAGE, SLOWEST_ATTACK_SPEED);
    public static final ToolSet PALLADIUM = new PalladiumToolSet(MythicToolMaterials.PALLADIUM, DEFAULT_DAMAGE, BETTER_AXE_ATTACK_SPEED, class_1792.class_1793::method_24359);
    public static final ToolSet PROMETHEUM = new PrometheumToolSet(MythicToolMaterials.PROMETHEUM, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet QUADRILLUM = new ToolSet(MythicToolMaterials.QUADRILLUM, DEFAULT_DAMAGE, SLOWEST_ATTACK_SPEED);
    public static final ToolSet RUNITE = new ToolSet(MythicToolMaterials.RUNITE, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet STAR_PLATINUM = new ToolSet(MythicToolMaterials.STAR_PLATINUM, DEFAULT_DAMAGE, FASTER_ATTACK_SPEED);
    public static final ToolSet STEEL = new SteelToolSet(MythicToolMaterials.STEEL, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet STORMYX = new ToolSet(MythicToolMaterials.STORMYX, DEFAULT_DAMAGE, DEFAULT_ATTACK_SPEED);
    public static final ToolSet TIDESINGER = new TidesingerToolSet(MythicToolMaterials.TIDESINGER, DEFAULT_DAMAGE, FASTER_ATTACK_SPEED);

    public static final class_1792 RED_AEGIS_SWORD = new RedAegisSword(MythicToolMaterials.AEGIS_RED, new class_1792.class_1793()
        .method_24359()
        .method_7894(class_1814.field_8907)
        .group(MythicMetals.TABBED_GROUP)
        .tab(2)
        .method_57348(class_1829.method_57394(MythicToolMaterials.AEGIS_RED, 5, -3.0f)));

    public static final class_1792 WHITE_AEGIS_SWORD = new class_1829(MythicToolMaterials.AEGIS_WHITE, new class_1792.class_1793()
        .method_24359()
        .method_7894(class_1814.field_8907)
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .method_57348(ToolSet.createAttributeModifiers(MythicToolMaterials.AEGIS_WHITE, 4, 1.4f))
    );

    public static final class_1792 CARMOT_BELL = new CarmotBellItem(new class_1792.class_1793()
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .method_7894(class_1814.field_8907)
        .method_7895(400)
    );

    public static final class_1792 CARMOT_STAFF = new CarmotStaffItem(MythicToolMaterials.CARMOT_STAFF,
        new class_1792.class_1793()
            .group(MythicMetals.TABBED_GROUP).tab(2)
    );

    public static final class_1792 ORICHALCUM_HAMMER = new HammerBase(MythicToolMaterials.ORICHALCUM, new class_1792.class_1793()
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .method_57348(class_1766.method_57346(MythicToolMaterials.ORICHALCUM, 6, -4.0f + 0.8f)),
        1
    );

    public static final class_1792 MIDAS_GOLD_SWORD = new MidasGoldSword(MythicToolMaterials.MIDAS_GOLD,
        new class_1792.class_1793()
            .group(MythicMetals.TABBED_GROUP).tab(2)
            .method_57348(class_1829.method_57394(MythicToolMaterials.MIDAS_GOLD, 3, -4.0f + 1.6f))
            .method_57349(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(0))
    );

    public static final class_1792 GILDED_MIDAS_GOLD_SWORD = new MidasGoldSword(MythicToolMaterials.GILDED_MIDAS_GOLD,
        new class_1792.class_1793()
            .method_24359()
            .method_7894(class_1814.field_8907)
            .group(MythicMetals.TABBED_GROUP).tab(2)
            .method_57348(class_1829.method_57394(MythicToolMaterials.GILDED_MIDAS_GOLD, 3, -4.0f + 1.6f))
            .method_57349(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(0))
    );

    public static final class_1792 ROYAL_MIDAS_GOLD_SWORD = new MidasGoldSword(MythicToolMaterials.ROYAL_MIDAS_GOLD,
        new class_1792.class_1793()
            .method_24359()
            .method_7894(class_1814.field_8907)
            .group(MythicMetals.TABBED_GROUP)
            .tab(2)
            .method_57348(class_1829.method_57394(MythicToolMaterials.ROYAL_MIDAS_GOLD, 3, -4.0f + 1.6f))
            .method_57349(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(0, true))
    );

    public static final class_1792 RUNITE_ARROW = new RuniteArrowItem(new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(2));
    public static final class_1792 TIPPED_RUNITE_ARROW = new TippedRuniteArrowItem(new class_1792.class_1793()
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .stackGenerator((item, stacks) -> {
            for (class_1842 potion : class_7923.field_41179) {
                var stack = class_1844.method_57400(item, RegistryHelper.getEntry(potion));
                if (!potion.method_8049().isEmpty()) {
                    stacks.method_45420(stack);
                }
            }
        })
        .method_57349(class_9334.field_49651, class_1844.field_49274)
    );

    public static final class_1792 STAR_PLATINUM_ARROW = new StarPlatinumArrowItem(new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(2));
    public static final class_1792 STORMYX_SHIELD = new StormyxShield(new class_1792.class_1793()
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .method_7895(1680)
        .method_7894(class_1814.field_8907)
        .method_57348(StormyxShield.createStormyxShieldAttributes())
    );
    public static final class_1792 MYTHRIL_DRILL = new MythrilDrill(MythicToolMaterials.MYTHRIL_DRILL, new class_1792.class_1793()
        .group(MythicMetals.TABBED_GROUP).tab(2)
        .method_7894(class_1814.field_8907)
        .method_57348(createAttributeModifiers(3, 1.5f))
        .method_57349(MythicDataComponents.DRILL, new DrillComponent(0))
        .method_57349(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2))
    );
    public static final class_1792 PLATINUM_WATCH = new class_1792(new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(2));

    @Override
    public void processField(ToolSet toolSet, String name, Field f) {
        toolSet.register(name);
        TOOL_MAP.put(name, toolSet);
    }

    @Override
    public Class<ToolSet> getTargetFieldType() {
        return ToolSet.class;
    }

    @Override
    public void afterFieldProcessing() {
        RegistryHelper.item("banglum_tnt_minecart", BANGLUM_TNT_MINECART);
        RegistryHelper.item("carmot_bell", CARMOT_BELL);
        RegistryHelper.item("palladium_minecart", PALLADIUM_MINECART);
        RegistryHelper.item("doge", Frogery.DOGE);
        RegistryHelper.item("froge", Frogery.FROGE);
        class_2378.method_47985(class_7923.field_41172, RegistryHelper.id("music_disc.dog4"), class_3414.method_47908(RegistryHelper.id("music_disc.dog4")));
        RegistryHelper.item("red_aegis_sword", RED_AEGIS_SWORD);
        RegistryHelper.item("white_aegis_sword", WHITE_AEGIS_SWORD);
        RegistryHelper.item("carmot_staff", CARMOT_STAFF);
        RegistryHelper.item("orichalcum_hammer", ORICHALCUM_HAMMER);
        RegistryHelper.item("midas_gold_sword", MIDAS_GOLD_SWORD);
        RegistryHelper.item("gilded_midas_gold_sword", GILDED_MIDAS_GOLD_SWORD);
        RegistryHelper.item("royal_midas_gold_sword", ROYAL_MIDAS_GOLD_SWORD);
        RegistryHelper.item("mythril_drill", MYTHRIL_DRILL);
        RegistryHelper.item("star_platinum_arrow", STAR_PLATINUM_ARROW);
        RegistryHelper.item("runite_arrow", RUNITE_ARROW);
        RegistryHelper.item("tipped_runite_arrow", TIPPED_RUNITE_ARROW);
        RegistryHelper.item("stormyx_shield", STORMYX_SHIELD);
        RegistryHelper.item("platinum_watch", PLATINUM_WATCH);
    }

    public static class Frogery {

        public static class Froger extends class_1792 {

            public Froger(class_1793 settings) {
                super(settings);
            }

            @Override
            public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
                if (entity.method_5864() == class_1299.field_37419 && FabricLoader.getInstance().isModLoaded("delightful-froge")) {
                    ((class_7102) entity).method_41353(class_7923.field_41164.method_55841(class_2960.method_60655("delightful", "froge")).orElseThrow());
                    return class_1269.field_5812;
                }
                return super.method_7847(stack, user, entity, hand);
            }
        }

        public static final class_1792 FROGE = new Froger(new class_1792.class_1793().method_7894(class_1814.field_8904).method_24359().equipmentSlot((entity, stack) -> class_1304.field_6169));
        public static final class_1792 DOGE = new class_1792(new class_1792.class_1793()
            .method_7894(class_1814.field_8904).method_24359()
            .equipmentSlot((entity, stack) -> class_1304.field_6169)
            .method_7889(1)
            .method_60745(class_5321.method_29179(class_7924.field_52176, RegistryHelper.id("dog4"))));
    }
}