package com.mythicmetals.item.tools;

import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.component.*;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.misc.RegistryHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.enchantment.*;
import net.minecraft.entity.*;
import net.minecraft.item.*;
import net.minecraft.util.*;
import org.joml.Math;
import java.util.*;

import static com.mythicmetals.component.DrillComponent.*;

public class MythrilDrill extends class_1766 implements AutoRepairable {

    /**
     * Map used to store the different types of drill upgrades
     * Used for handling tooltips
     */
    public static Map<class_1792, String> drillUpgrades = class_156.method_654(new HashMap<>(), map -> {
        map.put(MythicItems.Mats.AQUARIUM_PEARL, "aquarium");
        map.put(MythicItems.Mats.CARMOT_STONE, "carmot");
        map.put(MythicBlocks.ENCHANTED_MIDAS_GOLD_BLOCK_ITEM, "midas_gold");
        map.put(MythicItems.Mats.PROMETHEUM_BOUQUET, "prometheum");
        map.put(MythicItems.Mats.STORMYX_SHELL, "stormyx");
        map.put(class_1802.field_8162, "empty");
    });

    public MythrilDrill(class_1832 material, class_1792.class_1793 settings) {
        super(material, MythicTags.MINEABLE_MYTHRIL_DRILL, settings);
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        // If the Drill is in offhand, handle it normally when used on a block
        if (context.method_20287().equals(class_1268.field_5810)) {
            return super.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
        }
        // If the Drill is used on block in mainhand, cancel the action if a block is in the offhand and use the block instead
        if (context.method_20287().equals(class_1268.field_5808) && context.method_8036() != null) {
            var offhandStack = context.method_8036().method_5998(class_1268.field_5810);
            if (offhandStack != null && offhandStack.method_7909() != null && offhandStack.method_7909() instanceof class_1747 blockItem) {
                blockItem.method_7884(new class_1838(context.method_8045(), context.method_8036(), class_1268.field_5810, offhandStack, new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699())));
                context.method_8036().method_6104(class_1268.field_5810);
                return class_1269.field_33562;
            }
        }
        return super.method_7884(context);
    }

    @Override
    public boolean method_31565(class_1799 drill, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014) {
            var drillComponent = drill.method_57825(MythicDataComponents.DRILL, DEFAULT);
            // If right-clicking Drill onto Morkite, try to fuel it
            if (slot.method_7677().method_7909().equals(MythicItems.Mats.MORKITE)) {
                int morkiteCount = slot.method_7677().method_7947();
                if (slot.method_34264((MAX_FUEL - drillComponent.fuel()) / FUEL_CONSTANT, morkiteCount, player).isPresent()) {
                    int fuel = class_3532.method_15340(drillComponent.fuel() + (morkiteCount * FUEL_CONSTANT), 0, MAX_FUEL);
                    drill.method_57379(MythicDataComponents.DRILL, new DrillComponent(fuel));
                    return true;
                }
            }

        }
        return false;
    }

    @Override
    public boolean method_31566(class_1799 drill, class_1799 cursorStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014) {
            var cursorItem = cursorStack.method_7909();
            // If right-clicking with Morkite on Drill, try to fuel it
            if (cursorItem.equals(MythicItems.Mats.MORKITE)) {
                var drillComponent = drill.method_57825(MythicDataComponents.DRILL, DEFAULT);

                // Don't bother interacting if the Drills fuel is full
                if (drillComponent.fuel() >= MAX_FUEL) return false;

                // Greedily take all the morkite if we can, otherwise calculate how much to take
                int morkiteCount = cursorStack.method_7947();
                if (morkiteCount * FUEL_CONSTANT < (MAX_FUEL) - drillComponent.fuel()) {
                    int fuel = class_3532.method_15340(drillComponent.fuel() + (morkiteCount * FUEL_CONSTANT), 0, MAX_FUEL);
                    cursorStack.method_7934(morkiteCount);
                    drill.method_57379(MythicDataComponents.DRILL, new DrillComponent(fuel));
                    return true;
                }
                // Manually calculate how much Morkite to take
                if (morkiteCount * FUEL_CONSTANT >= (MAX_FUEL) - drillComponent.fuel()) {
                    int morkiteToTake = (MAX_FUEL / FUEL_CONSTANT) - (drillComponent.fuel() / FUEL_CONSTANT);
                    int fuel = class_3532.method_15340(drillComponent.fuel() + (morkiteToTake * FUEL_CONSTANT), 0, MAX_FUEL);
                    cursorStack.method_7934(morkiteToTake);
                    drill.method_57379(MythicDataComponents.DRILL, new DrillComponent(fuel));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (world.method_8608() && miner instanceof class_1657 player) {
            player.method_7353(class_2561.method_43471("tooltip.mythril_drill.out_of_fuel"), true);
            player.method_5783(class_3417.field_14624.comp_349(), 0.8f, 0.5f);
        }

        if (!world.field_9236 && state.method_26214(world, pos) != 0.0F) {
            // Randomly cancel damage while active
            var random = world.method_8409();
            var drillComponent = stack.method_57825(MythicDataComponents.DRILL, DEFAULT);
            var upgradeComponent = stack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2));

            if (!drillComponent.hasFuel()) {
                stack.method_7970(2, miner, class_1304.field_6173);
                return true;
            }

            if (random.method_43048(5) > 2) {
                stack.method_7970(1, miner, class_1304.field_6173);
            }
            stack.method_57379(MythicDataComponents.DRILL, drillComponent.reduce(drillComponent.fuel()));

            if (state.method_26164(ConventionalBlockTags.ORES)) {
                // Do not perform this if silk touch is present
                for (class_6880<class_1887> enchantment : stack.method_58657().method_57534()) {
                    if (enchantment.method_40220(MythicTags.SILK_TOUCH_LIKE)) {
                        return true;
                    }
                }

                // Restore air when mining ores underwater
                if (upgradeComponent.hasUpgrade(MythicItems.Mats.AQUARIUM_PEARL)) {
                    miner.method_5855(Math.min(miner.method_5669() + 60, miner.method_5748()));
                }
                // Randomly drop gold from midas gold
                if (upgradeComponent.hasUpgrade(MythicBlocks.ENCHANTED_MIDAS_GOLD_BLOCK.method_8389()) && random.method_43048(30) == 27) {
                    miner.method_5706(class_1802.field_33402);
                }
            }
        }

        return true;
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608()) {
            if (stack.method_57824(MythicDataComponents.DRILL) == null) return;
            if (stack.method_57824(MythicDataComponents.UPGRADES) == null) return;
            var drillComponent = stack.method_57825(MythicDataComponents.DRILL, DEFAULT);
            var upgradeComponent = stack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2));
            if (upgradeComponent.hasUpgrade(MythicItems.Mats.PROMETHEUM_BOUQUET)) {
                // Initialize auto repair upgrades
                if (!stack.method_57826(MythicDataComponents.PROMETHEUM)) {
                    stack.method_57379(MythicDataComponents.PROMETHEUM, PrometheumComponent.DEFAULT);
                }
                if (Math.floor(world.method_8510() % 20) == 0.0) {
                    stack.method_57379(MythicDataComponents.DRILL, drillComponent.increase(drillComponent.fuel()));
                }
                PrometheumComponent.tickAutoRepair(stack, world);
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> lines, class_1836 type) {
        if (stack.method_57826(MythicDataComponents.DRILL)) {
            stack.method_57825(MythicDataComponents.DRILL, DEFAULT).method_57409(context, lines::add, type);
        }
        if (stack.method_57826(MythicDataComponents.UPGRADES)) {
            var upgrades = stack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2));
            upgrades.method_57409(context, lines::add, type);
            for (int i = 0; i < upgrades.size(); i++) {
                var item = upgrades.items().get(i);
                lines.add(class_2561.method_43469("tooltip.mythril_drill.upgrade_slot", i + 1, class_2561.method_43471("tooltip.mythril_drill.upgrade." + drillUpgrades.get(item))));
            }
        }
    }

    @Override
    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        // Allow you to break blocks when fuel ticks down
        return oldStack.method_57826(MythicDataComponents.DRILL) && newStack.method_57826(MythicDataComponents.DRILL) || oldStack.method_7919() != newStack.method_7919();
    }

    @Override
    public float method_58404(class_1799 stack, class_2680 state) {
        if (stack.method_57825(MythicDataComponents.DRILL, DEFAULT).hasFuel()) {
            return super.method_58404(stack, state);
        }
        return 1.0f;
    }

    @Override
    public void method_7860(class_1799 stack) {
        if (!stack.method_57826(class_9334.field_49636)) return;

        boolean changes = false;
        var attributes = stack.method_57824(class_9334.field_49636);
        assert attributes != null;
        var upgrades = stack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2));
        if (upgrades.hasUpgrade(MythicBlocks.ENCHANTED_MIDAS_GOLD_BLOCK_ITEM)) {
            var modifier = new class_1322(
                RegistryHelper.id("mythril_drill_luck_bonus"),
                2.0,
                class_1322.class_1323.field_6328
            );
            attributes = attributes.method_57484(class_5134.field_23726, modifier, class_9274.field_49217);
            changes = true;
        }
        if (upgrades.hasUpgrade(MythicItems.Mats.AQUARIUM_PEARL)) {
            var modifier = new class_1322(
                RegistryHelper.id("mythril_drill_underwater_mining_bonus"),
                3.0,
                class_1322.class_1323.field_6328
            );
            attributes = attributes.method_57484(class_5134.field_51576, modifier, class_9274.field_49217);

            changes = true;
        }
        // Gives +1 level of efficiency
        for (var entry : stack.method_58657().method_57539()) {
            if (entry.getKey().method_40224(key -> key.equals(class_1893.field_9131))) {
                int level = class_1890.method_8225(entry.getKey(), stack);
                var modifier = new class_1322(
                    RegistryHelper.id("mythril_drill_speed_bonus"),
                    1 + (level * 2),
                    class_1322.class_1323.field_6328
                );
                attributes = attributes.method_57484(class_5134.field_51581, modifier, class_9274.field_49217);
                changes = true;
            }
        }
        if (changes) {
            stack.method_57379(class_9334.field_49636, attributes);
        }
    }
}
