package com.mythicmetals.item.tools;

import com.mythicmetals.effects.MythicStatusEffects;
import com.mythicmetals.misc.IsAttackCritical;
import com.mythicmetals.misc.RegistryHelper;
import io.wispforest.owo.ops.WorldOps;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.item.*;
import java.util.function.Consumer;

public class PalladiumToolSet extends ToolSet {
    // TODO - Move to config
    public static final int MAX_HEAT = 6;

    public PalladiumToolSet(class_1832 material, int[] damage, float[] speed, Consumer<class_1792.class_1793> settingsProcessor) {
        super(material, damage, speed, settingsProcessor);
    }

    @Override
    protected class_1829 makeSword(class_1832 material, int damage, float speed, class_1792.class_1793 settings) {
        return new PalladiumSword(material, settings.method_57348(createAttributeModifiers(material, damage, speed)));
    }

    @Override
    protected class_1743 makeAxe(class_1832 material, int damage, float speed, class_1792.class_1793 settings) {
        return new PalladiumAxe(material, settings.method_57348(createAttributeModifiers(material, damage, speed)));
    }

    @Override
    protected class_1810 makePickaxe(class_1832 material, int damage, float speed, class_1792.class_1793 settings) {
        return new PalladiumPick(material, settings.method_57348(createAttributeModifiers(material, damage, speed)));
    }

    @Override
    protected class_1821 makeShovel(class_1832 material, int damage, float speed, class_1792.class_1793 settings) {
        return new PalladiumShovel(material, settings.method_57348(createAttributeModifiers(material, damage, speed)));
    }

    @Override
    protected class_1794 makeHoe(class_1832 material, int damage, float speed, class_1792.class_1793 settings) {
        return new PalladiumHoe(material, settings.method_57348(createAttributeModifiers(material, damage, speed)));
    }

    public static class PalladiumAxe extends class_1743 {
        public PalladiumAxe(class_1832 material, class_1793 settings) {
            super(material, settings);
        }

        @Override
        public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            applyHeatToTarget(target, attacker);
            return super.method_7873(stack, target, attacker);
        }
    }

    public static class PalladiumHoe extends class_1794 {
        public PalladiumHoe(class_1832 material, class_1793 settings) {
            super(material, settings);
        }

        @Override
        public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            applyHeatToTarget(target, attacker);
            return super.method_7873(stack, target, attacker);
        }
    }

    public static class PalladiumPick extends class_1810 {
        public PalladiumPick(class_1832 material, class_1793 settings) {
            super(material, settings);
        }

        @Override
        public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            applyHeatToTarget(target, attacker);
            return super.method_7873(stack, target, attacker);
        }
    }

    public static class PalladiumShovel extends class_1821 {
        public PalladiumShovel(class_1832 material, class_1793 settings) {
            super(material, settings);
        }

        @Override
        public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            applyHeatToTarget(target, attacker);
            return super.method_7873(stack, target, attacker);
        }
    }

    public static class PalladiumSword extends class_1829 {
        public PalladiumSword(class_1832 material, class_1793 settings) {
            super(material, settings);
        }

        @Override
        public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            applyHeatToTarget(target, attacker);
            return super.method_7873(stack, target, attacker);
        }
    }

    public static void applyHeatToTarget(class_1309 target, class_1309 attacker) {
        var effect = RegistryHelper.getEntry(MythicStatusEffects.HEAT);
        if (!target.method_6059(effect)) {
            target.method_37222(new class_1293(effect, 100), attacker);
        } else {
            var activeEffect = target.method_6112(effect);
            int amplifier = activeEffect == null ? 0 : activeEffect.method_5578();
            if (((IsAttackCritical) attacker).mythicmetals$isCritical()) {
                amplifier += 1;
            } else if (target.method_59922().method_43048(3) == 0) {
                amplifier += 1;
            }

            if (amplifier >= MAX_HEAT) {
                WorldOps.playSound(target.method_37908(), target.method_19538(), class_3417.field_14821, class_3419.field_15248);
            }
            target.method_37222(new class_1293(effect, 100 + (20 * amplifier * amplifier), Math.min(amplifier, MAX_HEAT)), attacker);
        }
    }
}
