package com.mythicmetals.item.tools;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.item.*;

/**
 * Contains relevant methods which allow for the tool to use the Riptide ability of {@link class_1835}
 */
public interface RiptideTool {
    float TRIDENT_POWER = 3.0f;
    int COOLDOWN = 40;
    int MAX_USE_TIME = 72000;

    /**
     * Handles the activation of the Riptide ability. Requires you to be in water.
     * Override and call this in {@link class_1792#method_7836}
     * [VanillaCopy]
     *
     * @see class_1835#method_7836(class_1937, class_1657, class_1268)
     */
    default class_1271<class_1799> activateRiptide(class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (itemStack.method_7919() >= itemStack.method_7936() - 1) {
            return class_1271.method_22431(itemStack);
        } else if (!user.method_5721()) {
            return class_1271.method_22431(itemStack);
        } else if (user.method_7357().method_7904(itemStack.method_7909())) {
            return class_1271.method_22431(itemStack);
        } else {
            user.method_6019(hand);
            return class_1271.method_22428(itemStack);
        }
    }

    /**
     * Performs a Riptide. Requires you to be in water.
     * Override and call this in {@link class_1792#method_7840}
     *
     * @see class_1835#method_7840(class_1799, class_1937, class_1309, int)
     * [VanillaCopy] with only the riptide parts in mind, not the projectile logic
     */
    default void performRiptide(class_1799 stack, class_1937 world, class_1309 entity, int remainingUseTicks) {
        if (entity instanceof class_1657 user) {
            int i = MAX_USE_TIME - remainingUseTicks;
            if (i >= 10) {
                float f = class_1890.method_60123(stack, user) + TRIDENT_POWER;
                if (!(f > 0.0F) || user.method_5721()) {
                    // TridentItem#isAboutToBreak inline
                    if (!(stack.method_7919() >= stack.method_7936() - 1)) {
                        user.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
                        if (f > 0.0F) {
                            float g = user.method_36454();
                            float h = user.method_36455();
                            float j = -class_3532.method_15374(g * (float) (Math.PI / 180.0)) * class_3532.method_15362(h * (float) (Math.PI / 180.0));
                            float k = -class_3532.method_15374(h * (float) (Math.PI / 180.0));
                            float l = class_3532.method_15362(g * (float) (Math.PI / 180.0)) * class_3532.method_15362(h * (float) (Math.PI / 180.0));
                            float m = class_3532.method_15355(j * j + k * k + l * l);
                            j *= f / m;
                            k *= f / m;
                            l *= f / m;
                            user.method_5762(j, k, l);
                            user.method_40126(20, 8.0F, stack);
                            if (user.method_24828()) {
                                user.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999F, 0.0));
                            }

                            user.method_7357().method_7906(stack.method_7909(), COOLDOWN);
                            world.method_43129(null, user, class_3417.field_14717.comp_349(), class_3419.field_15248, 1.0F, 1.0F);
                        }
                    }
                }
            }
        }
    }
}
