package com.mythicmetals.misc;

import D;
import F;
import com.mojang.authlib.GameProfile;
import com.mythicmetals.item.tools.HammerBase;
import eu.pb4.common.protection.api.CommonProtection;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class BlockBreaker {

    public static boolean isProtected(class_1937 world, class_2338 blockPos, GameProfile profile, @Nullable class_1657 player) {
        return !CommonProtection.canBreakBlock(world, blockPos, profile, player);
    }

    public static boolean isProtected(class_1937 world, class_2338 blockPos, class_1927 explosion, GameProfile profile, @Nullable class_1657 player) {
        return !CommonProtection.canExplodeBlock(world, blockPos, explosion, profile, player);
    }

    public static Iterable<class_2338> findBlocks(class_1838 context, int depth) {

        Iterable<class_2338> iterator;

        var facing = context.method_8038().method_10153();
        var pos = context.method_8037();
        var pos2 = context.method_8037().method_10079(facing, depth);

        if (facing.equals(class_2350.field_11033) || facing.equals(class_2350.field_11036)) {
            iterator = class_2338.method_10097(
                pos.method_10078().method_10093(class_2350.field_11043),
                pos2.method_10067().method_10093(class_2350.field_11035)
            );
        } else {
            iterator = class_2338.method_10097(
                pos.method_10074().method_10093(facing.method_35834(class_2350.class_2351.field_11052)),
                pos2.method_10084().method_10093(facing.method_35833(class_2350.class_2351.field_11052))
            );
        }


        return iterator;
    }

    public static Iterable<class_2338> findBlocks(class_2350 facing, class_2338 pos, int depth) {
        Iterable<class_2338> iterator;

        var pos2 = pos.method_10079(facing, depth);

        if (facing.equals(class_2350.field_11033) || facing.equals(class_2350.field_11036)) {
            iterator = class_2338.method_10097(
                pos.method_10078().method_10093(class_2350.field_11043),
                pos2.method_10067().method_10093(class_2350.field_11035)
            );
        } else {
            iterator = class_2338.method_10097(
                pos.method_10074().method_10093(facing.method_35834(class_2350.class_2351.field_11052)),
                pos2.method_10084().method_10093(facing.method_35833(class_2350.class_2351.field_11052))
            );
        }

        return iterator;
    }

    public static double getReachDistance(class_1657 playerEntity) {
        return playerEntity.method_45325(class_5134.field_47758);
    }

    public static void initHammerTime() {
        // Original Block Pos is always the center block of where the hammer hits
        PlayerBlockBreakEvents.BEFORE.register((world, player, originalBlockPos, state, blockEntity) -> {
            var stack = player.method_6047();

            if (!(stack.method_7909() instanceof HammerBase hammer)) {
                return true; // don't do this for non-hammers
            }
            if (!hammer.method_58405(stack, state)) {
                return true; // don't break anything extra if you are not mining rocks or stones
            }
            if (isProtected(world, originalBlockPos, player.method_7334(), player)) {
                return false;
            }
            var reach = BlockBreaker.getReachDistance(player);

            class_3965 blockHitResult = (class_3965) player.method_5745(reach, 1, false);

            var facing = blockHitResult.method_17780().method_10153();
            var blocks = BlockBreaker.findBlocks(facing, originalBlockPos, hammer.getDepth());

            boolean hasMined = false;
            for (class_2338 pos : blocks) {
                // Ignore the center block, to prevent an edge case where the middle block is broken thrice
                if (pos.equals(originalBlockPos)) {
                    continue;
                }
                if (isProtected(world, pos, player.method_7334(), player)) continue;
                if (hammer.canBreak(stack, world, pos) && !player.method_7337()) {
                    // Call Block.onBreak here, to allow interactions when a player breaks blocks
                    // Note that the center block still calls onBreak twice
                    world.method_8320(pos).method_26204().method_9576(world, pos, state, player);
                    class_2586 breakEntity = world.method_8320(pos).method_26204() instanceof class_2343 ? world.method_8321(pos) : null;
                    class_2248.method_9511(world.method_8320(pos), world, originalBlockPos, breakEntity, player, stack);
                    world.method_8651(pos, false, player);
                    hasMined = true;
                } else if (player.method_7337()) {
                    world.method_8651(pos, false, null);
                }
            }
            if (hasMined) stack.method_7970(2, player, class_1304.field_6173);

            return true;
        });
    }

    public static float calculateHardestDelta(class_3965 blockHitResult, class_1657 player, HammerBase hammer) {
        // The hardest, and slowest, delta
        // This speed is how much progress you are making each tick (I think...)
        float hardestDelta = 1.0F;

        // Create an iterator around the blocks that are about to be broken
        var hammeredBlocks = BlockBreaker.findBlocks(
            blockHitResult.method_17780().method_10153(), blockHitResult.method_17777(), hammer.getDepth());

        for (class_2338 pos : hammeredBlocks) {
            var state = player.method_37908().method_8320(pos);
            // Ignore any blocks that are not minable
            if (!state.method_26215() && hammer.method_58405(hammer.method_7854(), state)) {
                // Set the current delta to the lowest value in the block iterator
                var delta = player.method_7351(state) / 30 / state.method_26214(player.method_37908(), pos);
                if (hardestDelta > delta) {
                    hardestDelta = delta;
                }
            }
        }

        return hardestDelta;
    }
}
