package com.mythicmetals.misc;

import com.mojang.authlib.GameProfile;
import com.mythicmetals.data.MythicTags;
import eu.pb4.common.protection.api.CommonProtection;
import net.minecraft.block.*;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2338.class_2339;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.jetbrains.annotations.Nullable;
import java.util.function.Predicate;

import static net.minecraft.class_2248.method_9511;

public final class EpicExplosion {
    private EpicExplosion() {

    }

    /**
     * Cause a large explosion
     *
     * @param world          World where the explosion happened
     * @param x              X-cord for the explosion center
     * @param y              Y-cord for the explosion center
     * @param z              Z-cord for the explosion center
     * @param radius         Explosion radius
     * @param statePredicate Blockstate predicate for filtering out specific blocks
     * @param exploder       Entity which caused the explosion
     * @param cause          PlayerEntity which triggered the explosion, used to check against claim protection
     */
    public static void explode(class_3218 world, int x, int y, int z, int radius, Predicate<class_2680> statePredicate,
                               @Nullable class_1297 exploder, @Nullable class_1657 cause) {
        int radiusSq = radius * radius;
        var pos = new class_2338.class_2339();
        class_1927 explosion = null;

        if (exploder != null) {
            explosion = new class_1927(world, exploder, x, y, z, radius, false, class_1927.class_4179.field_40879);
        }

        MythicParticleSystem.EXPLOSIVE_EXPLOSION.spawn(world, new class_243(x, y, z), (float) radius);

        GameProfile gameProfile = cause != null ? cause.method_7334() : CommonProtection.UNKNOWN;

        for (int ox = -radius; ox < radius; ox++) {
            for (int oy = -radius; oy < radius; oy++) {
                for (int oz = -radius; oz < radius; oz++) {
                    if (ox * ox + oy * oy + oz * oz > radiusSq) continue;

                    pos.method_10103(x + ox, y + oy, z + oz);
                    var state = world.method_8320(pos);

                    if (state.method_26215() || state.method_26204().method_9520() > 10000) continue;

                    if (!statePredicate.test(state)) continue;

                    if (explosion != null) {
                        if (BlockBreaker.isProtected(world, pos, explosion, gameProfile, cause)) continue;
                    } else {
                        if (BlockBreaker.isProtected(world, pos, gameProfile, cause)) continue;
                    }

                    world.method_8501(pos, class_2246.field_10124.method_9564());
                }
            }
        }

    }

    /**
     * Absorbs water around a center point in a given radius
     *
     * @param world  World where the explosion happened
     * @param x      X-cord for the center of this interaction
     * @param y      Y-cord for the center of this interaction
     * @param z      Z-cord for the center of this interaction
     * @param radius Water absorption radius
     * @param cause  PlayerEntity which triggered this, used to check against claim protection
     */
    public static void absorbWater(class_3218 world, int x, int y, int z, int radius, @Nullable class_1657 cause) {
        int radiusSq = radius * radius;
        var pos = new class_2338.class_2339();

        GameProfile playerId = cause != null ? cause.method_7334() : CommonProtection.UNKNOWN;

        for (int ox = -radius; ox < radius; ox++) {
            for (int oy = -radius; oy < radius; oy++) {
                for (int oz = -radius; oz < radius; oz++) {
                    if (ox * ox + oy * oy + oz * oz > radiusSq) continue;

                    pos.method_10103(x + ox, y + oy, z + oz);

                    if (!CommonProtection.canBreakBlock(world, pos, playerId, cause)) continue;

                    var state = world.method_8320(pos);
                    var fluidState = world.method_8316(pos);

                    if (fluidState.method_15767(class_3486.field_15517)) {
                        if (state.method_26204() instanceof class_2263 drainable && drainable.method_9700(cause, world, pos, state).method_7960()) {
                            world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31036);
                        } else if (state.method_26164(MythicTags.SPONGABLES)) {
                            class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
                            method_9610(state, world, pos, blockEntity);
                            world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31036);
                        }
                    }
                }
            }
        }

    }
}
