package com.mythicmetals.misc;

import com.mythicmetals.compat.ExplosiveEnhancementCompat;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.util.VectorRandomUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import java.util.Random;

public class MythicParticleSystem {
    public static final ParticleSystemController CONTROLLER = new ParticleSystemController(RegistryHelper.id("particles"));

    public static final ParticleSystem<class_243> EXPLOSION_TRAIL = CONTROLLER.register(class_243.class, (world, pos, pos2) -> {
        ClientParticles.reset();
        ClientParticles.setParticleCount(4);

        ClientParticles.spawnLine(class_2398.field_11236, world, pos, pos2, 2.0F);
    });

    public static final ParticleSystem<Void> CARMOT_TRAIL = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount(1);
        ClientParticles.setVelocity(new class_243(0, 0.1F, 0));
        ClientParticles.spawn(class_2398.field_11207, world, new class_243(pos.field_1352, pos.field_1351, pos.field_1350), 1.0D);
    });

    public static final ParticleSystem<Void> COPPER_SPARK = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount(1);
        ClientParticles.randomizeVelocity(1.25D);
        ClientParticles.spawn(class_2398.field_29644, world, pos, 1.0D);

    });

    public static final ParticleSystem<Void> SMOKING_PALLADIUM_PARTICLE = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount(1);
        Random r = new Random();
        var velocity = VectorRandomUtils.getRandomOffset(world,
            class_243.field_1353.method_1031(r.nextDouble(-1, 1), 0.75D, r.nextDouble(-1, 1)), 1.25D);
        ClientParticles.setVelocity(velocity);

        ClientParticles.spawn(class_2398.field_11251, world, pos, 0.0D);
    });

    public static final ParticleSystem<Void> OVERENGINEERED_PALLADIUM_PARTICLE = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.setParticleCount(1);
        Random r = new Random();
        var velocity = VectorRandomUtils.getRandomOffset(world,
            class_243.field_1353.method_1031(r.nextDouble(-1, 1), 0.75D, r.nextDouble(-1, 1)), 1.25D);
        ClientParticles.setVelocity(velocity);

        ClientParticles.spawn(class_2398.field_11239, world, pos, 0.0D);
    });

    public static final ParticleSystem<Double> HEALING_AREA = CONTROLLER.register(Double.class, (world, centre, size) -> {
        ClientParticles.reset();
        ClientParticles.setParticleCount(1);

        int particleCount = (int) (size * size);
        float position = (float) Math.PI;
        float step = position / particleCount * 2;

        for (int i = 0; i < particleCount; i++) {
            position -= step;
            ClientParticles.spawn(class_2398.field_11211, world, centre.method_1031(size * Math.sin(position), 0.25, size * Math.cos(position)), 0.0);
        }
    });

    public static final ParticleSystem<Void> HEALING_HEARTS = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.reset();
        ClientParticles.setParticleCount(5);

        ClientParticles.spawnWithOffsetFromBlock(class_2398.field_11201, world, class_2338.method_49638(pos), new class_243(0, 1.25, 0), 2.0F);

    });

    public static final ParticleSystem<Void> HEALING_DAMAGE = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.reset();
        ClientParticles.setParticleCount(5);

        ClientParticles.spawnWithOffsetFromBlock(class_2398.field_11208, world, class_2338.method_49638(pos), new class_243(0, 1.25, 0), 2.0F);

    });

    public static final ParticleSystem<Void> COMBUSTION_EXPLOSION = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.reset();
        ClientParticles.persist();
        ClientParticles.randomizeVelocity(0.5f);
        ClientParticles.setParticleCount(15);
        ClientParticles.spawn(class_2398.field_22247, world, pos.method_1031(0, 1, 0), 3.0f);
        ClientParticles.spawn(class_2398.field_11239, world, pos.method_1031(0, 1, 0), 3.0f);
        ClientParticles.spawn(class_2398.field_11251, world, pos.method_1031(0, 1, 0), 3.0f);
    });

    public static final ParticleSystem<Void> COLORED_NOTE = CONTROLLER.register(Void.class, (world, pos, data) -> {
        Random r = new Random();
        ClientParticles.reset();
        ClientParticles.persist();
        ClientParticles.setParticleCount(1);
        ClientParticles.setVelocity(new class_243(r.nextInt(32) / 16.0f, 0, 0));
        ClientParticles.spawn(class_2398.field_11224, world, pos, 0);
        ClientParticles.reset();
    });

    public static final ParticleSystem<Void> NOTE_EXPLOSION = CONTROLLER.register(Void.class, (world, pos, data) -> {
        final int COUNT = 8;
        Random r = new Random();
        ClientParticles.reset();
        ClientParticles.persist();
        ClientParticles.setParticleCount(1);
        for (int i = 0; i < COUNT; i++) {
            ClientParticles.setVelocity(new class_243(r.nextInt(32) / 16.0f, 0, 0));
            double xOffset = r.nextDouble(-1.0, 1.0);
            double yOffset = r.nextDouble(-0.5, 2.0);
            double zOffset = r.nextDouble(-1.0, 1.0);
            ClientParticles.spawn(class_2398.field_11224, world, pos.method_1031(xOffset, yOffset, zOffset), 0.25f);
        }
    });

    public static final ParticleSystem<Void> RESONATOR_PARTICLES = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.reset();
        ClientParticles.persist();
        ClientParticles.setParticleCount(4);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_11229, world, class_2338.method_49638(pos.method_1031(0, 1.0, 0)), 2.0);
    });

    public static final ParticleSystem<Void> RESONATOR_POWER_PARTICLES = CONTROLLER.register(Void.class, (world, pos, data) -> {
        ClientParticles.reset();
        ClientParticles.persist();
        ClientParticles.setParticleCount(4);
        ClientParticles.spawnWithOffsetFromBlock(class_2398.field_11229, world, class_2338.method_49638(pos), new class_243(0, 1.25, 0), 2.0F);
    });

    public static final ParticleSystem<Float> EXPLOSIVE_EXPLOSION = CONTROLLER.register(Float.class, (world, pos, power) -> {
        if (FabricLoader.getInstance().isModLoaded("explosiveenhancement")) {
            ExplosiveEnhancementCompat.spawnParticles(world, pos.field_1352, pos.field_1351, pos.field_1350, power);
        }
    });

    public static void init() {
    }
}
