package com.mythicmetals.misc;

import com.mojang.serialization.MapCodec;
import com.mythicmetals.MythicMetals;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1842;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9331;
import net.minecraft.item.*;
import net.minecraft.registry.*;
import java.util.function.UnaryOperator;

/**
 * A helper class containing methods for registering various blocks and items.
 *
 * @author Noaaan
 */
public class RegistryHelper {

    public static class_2960 id(String path) {
        return class_2960.method_60655(MythicMetals.MOD_ID, path);
    }

    public static void item(String path, class_1792 item) {
        class_2378.method_10230(class_7923.field_41178, id(path), item);
    }

    public static void block(String path, class_2248 block) {
        class_2378.method_10230(class_7923.field_41175, id(path), block);
        class_2378.method_10230(class_7923.field_41178, id(path), new class_1747(block, new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(1)));
    }

    public static void block(String path, class_2248 block, boolean fireproof) {
        if (fireproof) {
            class_2378.method_10230(class_7923.field_41175, id(path), block);
            class_2378.method_10230(class_7923.field_41178, id(path), new class_1747(block, new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(1).method_24359()));
        } else {
            block(path, block);
        }
    }

    public static void block(String path, class_2248 block, boolean fireproof, boolean uncommon) {
        if (uncommon) {
            class_2378.method_10230(class_7923.field_41175, id(path), block);
            class_2378.method_10230(class_7923.field_41178, id(path), new class_1747(block, new class_1792.class_1793().group(MythicMetals.TABBED_GROUP).tab(1).method_7894(class_1814.field_8907)));
        } else {
            block(path, block, fireproof);
        }
    }

    public static void block(String path, class_2248 block, OwoItemGroup group) {
        class_2378.method_10230(class_7923.field_41175, id(path), block);
        class_2378.method_10230(class_7923.field_41178, id(path), new class_1747(block, new class_1792.class_1793().group(group)));
    }

    public static void block(String path, class_2248 block, OwoItemGroup group, boolean fireproof) {
        if (fireproof) {
            class_2378.method_10230(class_7923.field_41175, id(path), block);
            class_2378.method_10230(class_7923.field_41178, id(path), new class_1747(block, new class_1792.class_1793().group(group).method_24359()));
        } else {
            block(path, block, group);
        }
    }

    public static void blockOnly(String path, class_2248 block) {
        class_2378.method_10230(class_7923.field_41175, id(path), block);
    }

    public static void entityType(String path, class_1299<?> type) {
        class_2378.method_10230(class_7923.field_41177, RegistryHelper.id(path), type);
    }

    public static class_5321<class_2975<?, ?>> configuredFeatureKey(String path) {
        return class_5321.method_29179(class_7924.field_41239, RegistryHelper.id(path));
    }

    public static class_5342 lootConditionType(String path, MapCodec<? extends class_5341> lootCodec) {
        return class_2378.method_10230(class_7923.field_41135, RegistryHelper.id(path), new class_5342(lootCodec));
    }

    public static void blockEntity(String path, class_2591<?> type) {
        class_2378.method_10230(class_7923.field_41181, RegistryHelper.id(path), type);
    }

    public static class_6880<class_1320> entityAttribute(String path, class_1320 attribute) {
        return class_2378.method_47985(class_7923.field_41190, id(path), attribute);
    }

    public static class_6880<class_1291> getEntry(class_1291 effect) {
        return class_7923.field_41174.method_47983(effect);
    }

    public static class_6880<class_1741> getEntry(class_1741 material) {
        return class_7923.field_48976.method_47983(material);
    }

    public static class_6880<class_1842> getEntry(class_1842 potion) {
        return class_7923.field_41179.method_47983(potion);
    }

    public static <T> class_9331<T> dataComponentType(String path, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(class_7923.field_49658, id(path), builderOperator.apply(class_9331.method_57873()).method_57880());
    }

    public static class_6880<class_1842> potion(String name, class_1293 statusEffectInstance) {
        return class_2378.method_47985(class_7923.field_41179, id(name), new class_1842(statusEffectInstance));
    }
}
