package com.mythicmetals.misc;

import io.wispforest.owo.ui.core.Color;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_9334;

public class UsefulSingletonForColorUtil {
    public static float[] splitRGBToFloats(int rgb) {
        return new float[]{(rgb >> 16) / 255f, ((rgb >> 8) & 0xFF) / 255f, (rgb & 0xFF) / 255f};
    }

    // thx chyzman
    public static int getSlightlyDarkerOwoBlueToRedGradient(float currentValue, float maxValue) {
        return Color.RED.interpolate(Color.ofRgb(0x3955E5), currentValue / maxValue).rgb();
    }

    /**
     * Calculates a tint-index from a potion color
     * Borrowed from <a href="https://github.com/DaFuqs/Spectrum/blob/227502412912cb94f8d1d6335c94a00a91a1fe84/src/main/java/de/dafuqs/spectrum/registries/client/SpectrumColorProviders.java#L169">...</a>
     *
     * @param stack     Stack with Potion Effect
     * @param tintIndex Tint index
     * @return Color as int
     * @author DaFuqs
     */
    public static int potionColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 1) {
            var component = stack.method_57825(class_9334.field_49651, class_1844.field_49274);
            if (component == null) {
                return -1;
            }
            if (component.comp_2379().isPresent()) {
                return component.comp_2379().get();
            }

            if (component.method_57405()) {
                return class_1844.method_8055(component.method_57397());
            }
        }
        return -1;
    }

    public static int rainbow() {
        double delta = System.currentTimeMillis() / 45.0;

        double hue = delta % 360.0;
        float saturation = 1;
        float constantValue = 1;

        return class_3532.method_60599((float) (hue / 360), saturation, constantValue, 192);
    }

    /**
     * Contains constants for all the colors used for various text and particles
     */
    public static class MetalColors {
        public static final Color BANGLUM = Color.ofFormatting(class_124.field_1065);
        public static final Color CARMOT = Color.ofRgb(0xE63E73);
        public static final Color OSMIUM = Color.ofRgb(0x4C63A5);
        public static final class_2583 CARMOT_STYLE = class_2583.field_24360.method_36139(CARMOT.rgb());
        public static final Color MORKITE = Color.ofRgb(0x00E3D6);
        public static final Color MYTHRIL = Color.ofRgb(0x3485C8);
        public static final Color RED_AEGIS = Color.ofRgb(0xDA1F00);
        public static final Color STARRITE = Color.ofRgb(0xF56CE3);
        public static final Color PALLADIUM = Color.ofRgb(0xDF7323);
        public static final Color PROMETHEUM = Color.ofRgb(0x3A6A56);
        public static final Color KYBER = Color.ofRgb(0xDEA5FF);
        public static final class_2583 AQUA_STYLE = class_2583.field_24360.method_10977(class_124.field_1075);
        public static final class_2583 GOLD_STYLE = class_2583.field_24360.method_10977(class_124.field_1065);
        public static final class_2583 PALLADIUM_STYLE = class_2583.field_24360.method_36139(MetalColors.PALLADIUM.rgb());
        public static final class_2583 TIDESINGER_BLUE = class_2583.field_24360.method_36139(0x2F88FB);

        public static final int SHIELD_BREAK_COLOR = class_3532.method_60599(0f, 1.0f, 1.0f, 128);

        public static final CoralColor BRAIN = new CoralColor("brain", class_2583.field_24360.method_36139(0xE17DB7));
        public static final CoralColor BUBBLE = new CoralColor("bubble", class_2583.field_24360.method_36139(0xCB44BD));
        public static final CoralColor FIRE = new CoralColor("fire", class_2583.field_24360.method_36139(0xA2222E));
        public static final CoralColor HORN = new CoralColor("horn", class_2583.field_24360.method_36139(0xEAE94B));
        public static final CoralColor TUBE = new CoralColor("tube", class_2583.field_24360.method_36139(0x3F5BDF));
    }

    public record CoralColor(String name, class_2583 style) {
    }
}
