package com.mythicmetals.mixin;

import F;
import com.mythicmetals.item.tools.HammerBase;
import com.mythicmetals.misc.BlockBreaker;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4970.class_4971.class)
public class AbstractBlockStateMixin {

    @Inject(at = @At("RETURN"), method = "calcBlockBreakingDelta", cancellable = true)
    private void mythicmetals$slowBreaking(class_1657 player, class_1922 blockView, class_2338 originalBlockPos, CallbackInfoReturnable<Float> cir) {
        if (player.method_6047().method_7909() instanceof HammerBase hammer) {
            var oldDelta = cir.getReturnValue();
            // Raycast to get a block hit result, which contains the side of the targeted block
            class_3965 blockHitResult = blockView.method_17742(
                new class_3959(player.method_19538(),
                    class_243.method_24954(originalBlockPos),
                    class_3959.class_3960.field_17559,
                    class_3959.class_242.field_1348,
                    player));

            var hammerDelta = BlockBreaker.calculateHardestDelta(blockHitResult, player, hammer);

            cir.setReturnValue(Math.min(oldDelta, hammerDelta));
        }
    }
}

