package com.mythicmetals.mixin;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.block.Lavaloggable;
import com.mythicmetals.block.PalladiumRailBlock;
import com.mythicmetals.entity.BanglumTntMinecartEntity;
import com.mythicmetals.entity.PalladiumMinecartEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1688.class)
public class AbstractMinecartEntityMixin {

    @Inject(method = "create", at = @At("HEAD"), cancellable = true)
    private static void mythicmetals$createCustomMinecart(class_3218 world, double x, double y, double z, class_1688.class_1689 type, class_1799 stack, class_1657 player, CallbackInfoReturnable<class_1688> cir) {
        if (type.equals(MythicMetals.BANGLUM_TNT)) {
            cir.setReturnValue(new BanglumTntMinecartEntity(world, x, y, z));
        }

        if (type.equals(MythicMetals.PALLADIUM_MINECART)) {
            cir.setReturnValue(new PalladiumMinecartEntity(world, x, y, z));
        }
    }

    @ModifyVariable(method = "moveOnRail", at = @At(value = "STORE", ordinal = 0))
    private boolean mythicmetals$boostInLava(boolean original, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof Lavaloggable && PalladiumRailBlock.isLavaLogged(state)) {
            return true;
        }
        return original;
    }
}
