package com.mythicmetals.mixin;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.UpgradeComponent;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.MythicItems;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import net.minecraft.class_94;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_94.class)
public class ApplyBonusLootFunctionMixin {

    @Shadow
    @Final
    private class_6880<class_1887> enchantment;

    @ModifyVariable(method = "process",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/loot/context/LootContext;getRandom()Lnet/minecraft/util/math/random/Random;",
            shift = At.Shift.BEFORE),
        ordinal = 0
    )
    private int mythicmetals$increaseFortune(int level, class_1799 drop, class_47 lootCtx) {
        // Only increase drops from Fortune
        if (!this.enchantment.method_40224((enchantmentRegistryKey) -> enchantmentRegistryKey.equals(class_1893.field_9130))) {
            return level;
        }

        // Return early if there is no item
        var toolCtxStack = lootCtx.method_296(class_181.field_1229);
        if (toolCtxStack == null) {
            return level;
        }

        if (toolCtxStack.method_31573(MythicTags.BONUS_FORTUNE)) {
            return level + 1;
        }

        if (toolCtxStack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2)).hasUpgrade(MythicItems.Mats.CARMOT_STONE)) {
            return level + 1;
        }
        return level;
    }
}
