package com.mythicmetals.mixin;

import com.mythicmetals.misc.WasSpawnedFromCreeper;
import net.minecraft.class_1295;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_1295.class)
public abstract class AreaEffectCloudEntityMixin implements WasSpawnedFromCreeper {

    @Unique
    private boolean mythicmetals$ownerWasCreeper = false;

    @Override
    public void mythicmetals$setSpawnedFromCreeper(boolean isCreeper) {
        mythicmetals$ownerWasCreeper = isCreeper;
    }

    @Override
    public boolean mythicmetals$isSpawnedFromCreeper() {
        return mythicmetals$ownerWasCreeper;
    }
}
