package com.mythicmetals.mixin;

import com.mythicmetals.armor.MythicArmorMaterials;
import com.mythicmetals.entity.MythicEntityAttributes;
import com.mythicmetals.misc.RegistryHelper;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.entity.attribute.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import static net.minecraft.class_1322.class_1323.*;

@Mixin(class_1738.class)
public abstract class ArmorItemMixin {

    @Inject(method = "method_56689", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/Identifier;ofVanilla(Ljava/lang/String;)Lnet/minecraft/util/Identifier;"), locals = LocalCapture.CAPTURE_FAILSOFT)
    private static void constructor(class_6880<?> registryEntry, class_1738.class_8051 type, CallbackInfoReturnable<class_9285> cir, int i, float f, class_9285.class_9286 builder, class_9274 slot) {
        var material = registryEntry.comp_349();
        if (material == MythicArmorMaterials.TIDESINGER) {
            mythicmetals$armorMapBuilder(builder, "tidesinger_%s_swim_speed_bonus".formatted(type.method_48400()), AdditionalEntityAttributes.WATER_SPEED, 0.1F, field_6331, slot);
            switch (type) {
                case field_41934 -> {
                    mythicmetals$armorMapBuilder(builder, "tidesinger_helmet_underwater_mining_bonus", class_5134.field_51576, 3.0f, field_6331, slot);
                    mythicmetals$armorMapBuilder(builder, "tidesinger_helmet_vision_bonus", AdditionalEntityAttributes.WATER_VISIBILITY, 0.3f, field_6331, slot);
                }
                case field_41935, field_41936 ->
                    mythicmetals$armorMapBuilder(builder, "tidesinger_%s_oxygen_bonus".formatted(type.method_48400()), class_5134.field_51583, 2.0f, field_6328, slot);
                case field_41937 ->
                    mythicmetals$armorMapBuilder(builder, "tidesinger_boots_depth_strider_bonus", class_5134.field_51578, 1.0f, field_6331, slot);
            }

        }
        if (material.equals(MythicArmorMaterials.AQUARIUM)) {
            switch (type) {
                case field_41934 ->
                    mythicmetals$armorMapBuilder(builder, "aquarium_helmet_underwater_mining_bonus", class_5134.field_51576, 1.0f, field_6330, slot);
                case field_41935, field_41936 ->
                    mythicmetals$armorMapBuilder(builder, "aquarium_%s_oxygen_bonus".formatted(type.method_48400()), class_5134.field_51583, 1.0f, field_6328, slot);
                case field_41937 ->
                    mythicmetals$armorMapBuilder(builder, "aquarium_boots_depth_strider_bonus", class_5134.field_51578, 0.5F, field_6328, slot);
            }
        }
        if (material.equals(MythicArmorMaterials.CELESTIUM)) {
            mythicmetals$armorMapBuilder(builder, "celestium_%s_speed_bonus".formatted(type.method_48400()), class_5134.field_23719, 0.1F, field_6331, slot);
            mythicmetals$armorMapBuilder(builder, "celestium_%s_damage_bonus".formatted(type.method_48400()), class_5134.field_23721, 1.0F, field_6328, slot);
        }
        if (material.equals(MythicArmorMaterials.MIDAS_GOLD)) {
            mythicmetals$armorMapBuilder(builder, "midas_%s_luck_bonus".formatted(type.method_48400()), class_5134.field_23726, 1.0F, field_6328, slot);
        }
        if (material.equals(MythicArmorMaterials.STAR_PLATINUM)) {
            mythicmetals$armorMapBuilder(builder, "star_platinum_%s_attack_bonus".formatted(type.method_48400()), class_5134.field_23721, 1.0F, field_6328, slot);
        }
        if (material.equals(MythicArmorMaterials.CARMOT)) {
            mythicmetals$armorMapBuilder(builder, "carmot_%s_carmot_shield_bonus".formatted(type.method_48400()), MythicEntityAttributes.CARMOT_SHIELD, 5.0F, field_6328, slot);
            mythicmetals$armorMapBuilder(builder, "carmot_%s_health_bonus".formatted(type.method_48400()), class_5134.field_23716, 2.0F, field_6328, slot);
        }
        if (material.equals(MythicArmorMaterials.STORMYX)) {
            mythicmetals$armorMapBuilder(builder, "stormyx_%s_magic_protection".formatted(type.method_48400()), AdditionalEntityAttributes.MAGIC_PROTECTION, 2.0f, field_6328, slot);
        }
        if (material.equals(MythicArmorMaterials.PALLADIUM)) {
            if (type.method_48399().equals(class_1304.field_6169)) {
                mythicmetals$armorMapBuilder(builder, "palladium_%s_lava_vision_bonus".formatted(type.method_48400()), AdditionalEntityAttributes.LAVA_VISIBILITY, 8.0f, field_6328, slot);
            } else {
                mythicmetals$armorMapBuilder(builder, "palladium_%s_lava_speed_bonus".formatted(type.method_48400()), AdditionalEntityAttributes.LAVA_SPEED, 0.1f, field_6331, slot);
            }
            mythicmetals$armorMapBuilder(builder, "palladium_%s_burn_time_reduction_bonus".formatted(type.method_48400()), class_5134.field_51579, -0.25f, field_6330, slot);
        }
    }

    @Unique
    private static void mythicmetals$armorMapBuilder(class_9285.class_9286 builder, String id, class_6880<class_1320> attributeEntry, float value, class_1322.class_1323 operation, class_9274 slot) {
        builder.method_57487(attributeEntry, new class_1322(RegistryHelper.id(id), value, operation), slot);
    }

}
