package com.mythicmetals.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.mythicmetals.block.Lavaloggable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1755.class)
public abstract class BucketItemMixin {

    @Shadow @Final private class_3611 fluid;

    @Shadow protected abstract void playEmptyingSound(@Nullable class_1657 player, class_1936 world, class_2338 pos);

    @ModifyVariable(method = "use", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;getBlock()Lnet/minecraft/block/Block;"), ordinal = 1)
    private class_2338 mythicmetals$targetBlockOnLava(class_2338 original, class_1937 world, class_1657 user, class_1268 hand, @Local class_2680 blockState, @Local class_3965 blockHitResult) {
        if (blockState.method_26204() instanceof Lavaloggable && this.fluid.equals(class_3612.field_15908)) {
            return blockHitResult.method_17777();
        }
        return original;
    }

    @Inject(method = "placeFluid", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;isLiquid()Z"), cancellable = true)
    private void mythicmetals$fillLavalog(class_1657 player, class_1937 world, class_2338 pos, class_3965 hitResult, CallbackInfoReturnable<Boolean> cir) {
        var state = world.method_8320(pos);
        if (this.fluid.equals(class_3612.field_15908) && state.method_26204() instanceof Lavaloggable lavaloggable) {
            // TODO - Vanilla behavior here is to eat the fluid if you log the same block twice
            // Try and explore whether you can prevent placing lava in the same block twice
            // Lava is mildly more inconvenient to source, after all
            lavaloggable.method_10311(world, pos, state, class_3612.field_15908.method_15729(false));
            this.playEmptyingSound(player, world, pos);
            cir.setReturnValue(true);
        }
    }
}
