package com.mythicmetals.mixin;

import com.mythicmetals.armor.MythicArmor;
import com.mythicmetals.client.models.MythicModelHandler;
import com.mythicmetals.client.models.StarPlatCloakModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRenderEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_972;
import net.minecraft.client.render.*;
import net.minecraft.client.render.entity.feature.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_972.class)
public abstract class CapeFeatureRendererMixin extends class_3887<class_742, class_591<class_742>> {

    public CapeFeatureRendererMixin(class_3883<class_742, class_591<class_742>> ctx) {
        super(ctx);
    }

    @Inject(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;FFFFFF)V", at = @At("HEAD"), cancellable = true)
    public void render(class_4587 ms, class_4597 vertices, int light, class_742 player, float f, float g, float h, float j, float k, float l, CallbackInfo ci) {
        if (!player.method_7348(class_1664.field_7559) || player.method_52814().comp_1627() != null) return;
        if (!LivingEntityFeatureRenderEvents.ALLOW_CAPE_RENDER.invoker().allowCapeRender(player))
            return;

        // Custom Hallowed Cape when no other cape is present
        if (player.method_6118(class_1304.field_6174).method_7909() == MythicArmor.HALLOWED.getChestplate().method_8389()) {
            mythicmetals$renderHallowedCape(ms, vertices, light, player, f, g, h, j, k, l);
            ci.cancel();
            return;
        }
        // Custom Star Platinum Cloak when no other cape is present
        if (player.method_6118(class_1304.field_6174).method_7909() == MythicArmor.STAR_PLATINUM.getChestplate().method_8389()) {
            mythicmetals$renderStarPlatCape(ms, vertices, light, player, f, g, h, j, k, l);
            ci.cancel();
        }
    }

    @Unique
    private void mythicmetals$renderStarPlatCape(class_4587 ms, class_4597 vertices, int light, class_742 player, float f, float g, float h, float j, float k, float l) {
        double x = class_3532.method_17821(h, (float) player.field_7524, (float) player.field_7500)
            - class_3532.method_17821(h, (float) player.field_6014, (float) player.method_23317());
        double y = class_3532.method_17821(h, (float) player.field_7502, (float) player.field_7521)
            - class_3532.method_17821(h, (float) player.field_6036, (float) player.method_23318());
        double z = class_3532.method_17821(h, (float) player.field_7522, (float) player.field_7499)
            - class_3532.method_17821(h, (float) player.field_5969, (float) player.method_23321());
        float yaw = player.field_6220 + (player.field_6283 - player.field_6220);
        double o = class_3532.method_15374(yaw * (float) (Math.PI / 180.0));
        double p = -class_3532.method_15362(yaw * (float) (Math.PI / 180.0));
        float q = (float) y * 10.0F;
        q = class_3532.method_15363(q, -6.0F, 32.0F);
        float r = (float) (x * o + z * p) * 100.0F;
        r = class_3532.method_15363(r, 0.0F, 150.0F);
        float capeZOffset = (float) (x * p - z * o) * 100.0F;
        capeZOffset = class_3532.method_15363(capeZOffset, -20.0F, 20.0F);
        if (r < 0.0F) {
            r = 0.0F;
        }


        float t = class_3532.method_16439(h, player.field_7505, player.field_7483);
        q += class_3532.method_15374(class_3532.method_16439(h, player.field_6039, player.field_5973) * 6.0F) * 32.0F * t;

        if (player.method_18276()) {
            q += 25.0F;
        }

        float backCapeRotation = class_3532.method_15363(6.0F + r / 2.0F + q, -30, 60);
        class_4588 vertexConsumer = vertices.getBuffer(class_1921.method_23572(MythicModelHandler.STAR_PLATINUM_CLOAK));

        // Transform and render the custom cape
        ms.method_22903();
        ms.method_22904(0, -0.05, 0.0); // Push up and backwards, then rotate
        ms.method_22907(class_7833.field_40714.rotationDegrees(backCapeRotation));
        ms.method_22907(class_7833.field_40718.rotationDegrees(capeZOffset / 2.0F));
        ms.method_22907(class_7833.field_40716.rotationDegrees(180.0F - capeZOffset / 1.25F));
        ms.method_22904(0, 0.05, -0.370); // Move back down
        if (player.method_18276()) {
            ms.method_22904(0, 0.15, 0.125);
        }


        StarPlatCloakModel.CAPE_MODEL.method_22698(ms, vertexConsumer, light, class_4608.field_21444);
        ms.method_22909();
    }

    // [VanillaCopy] render the cape
    @Unique
    private void mythicmetals$renderHallowedCape(class_4587 ms, class_4597 vertices, int light, class_742 player, float f, float g, float h, float j, float k, float l) {
        ms.method_22903();
        ms.method_22904(0.0, 0.0, 0.125);
        double x = class_3532.method_16436(h, player.field_7524, player.field_7500)
            - class_3532.method_16436(h, player.field_6014, player.method_23317());
        double y = class_3532.method_16436(h, player.field_7502, player.field_7521)
            - class_3532.method_16436(h, player.field_6036, player.method_23318());
        double z = class_3532.method_16436(h, player.field_7522, player.field_7499)
            - class_3532.method_16436(h, player.field_5969, player.method_23321());
        float yaw = player.field_6220 + (player.field_6283 - player.field_6220);
        double o = class_3532.method_15374(yaw * (float) (Math.PI / 180.0));
        double p = -class_3532.method_15362(yaw * (float) (Math.PI / 180.0));
        float q = (float) y * 10.0F;
        q = class_3532.method_15363(q, -6.0F, 32.0F);
        float r = (float) (x * o + z * p) * 100.0F;
        r = class_3532.method_15363(r, 0.0F, 150.0F);
        float s = (float) (x * p - z * o) * 100.0F;
        s = class_3532.method_15363(s, -20.0F, 20.0F);
        if (r < 0.0F) {
            r = 0.0F;
        }

        float t = class_3532.method_16439(h, player.field_7505, player.field_7483);
        q += class_3532.method_15374(class_3532.method_16439(h, player.field_6039, player.field_5973) * 6.0F) * 32.0F * t;
        if (player.method_18276()) {
            q += 25.0F;
        }

        ms.method_22907(class_7833.field_40714.rotationDegrees(6.0F + r / 2.0F + q));
        ms.method_22907(class_7833.field_40718.rotationDegrees(s / 2.0F));
        ms.method_22907(class_7833.field_40716.rotationDegrees(180.0F - s / 2.0F));
        class_4588 vertexConsumer = vertices.getBuffer(class_1921.method_23580(MythicModelHandler.HALLOWED_CAPE));
        this.method_17165().method_2823(ms, vertexConsumer, light, class_4608.field_21444);
        ms.method_22909();
    }
}
