package com.mythicmetals.mixin;

import com.mythicmetals.block.ConduitPowered;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.registry.RegisterPointOfInterests;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2597;
import net.minecraft.class_3218;
import net.minecraft.class_4153;

@Mixin(class_2597.class)
public class ConduitBlockEntityMixin {

    @Mutable
    @Shadow
    @Final
    private static class_2248[] ACTIVATING_BLOCKS;

    @Inject(method = "<clinit>", at = @At("TAIL"))
    private static void mythicmetals$extendConduitArray(CallbackInfo ci) {
        List<class_2248> blocks = Arrays.stream(ACTIVATING_BLOCKS).collect(Collectors.toList());
        blocks.add(MythicBlocks.AQUARIUM_GLASS);
        blocks.add(MythicBlocks.AQUARIUM.getStorageBlock());

        ACTIVATING_BLOCKS = blocks.toArray(ACTIVATING_BLOCKS);
    }

    @Inject(method = "givePlayersEffects", at = @At("TAIL"))
    private static void mythicmetals$invokeNearbySentries(class_1937 world, class_2338 pos, List<class_2338> activatingBlocks, CallbackInfo ci) {
        if (world.field_9236) return;
        int radius = activatingBlocks.size() / 7 * 16;
        ((class_3218)world).method_19494()
            .method_22383(type -> type.comp_349() == RegisterPointOfInterests.CONDUIT_POWERED_BLOCK, pos, radius, class_4153.class_4155.field_18489)
            .forEach(pointOfInterest -> {
                var blockEntity = world.method_8321(pointOfInterest.method_19141());
                if (blockEntity instanceof ConduitPowered conduitPowered) {
                    conduitPowered.activate();
                }
            });
    }

}
