package com.mythicmetals.mixin;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.misc.LegacyIds;
import net.minecraft.class_2348;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

// This Mixin is a class that works as a datafixer.
// Upon loading a world it will check for missing objects in the recipe and replace them in order to
// prevent air pockets when upgrading from older worlds, as well as returning changed/removed items.
@Mixin(class_2348.class)
public class DefaultedRegistryMixin {

    @ModifyVariable(at = @At("HEAD"), method = "get(Lnet/minecraft/util/Identifier;)Ljava/lang/Object;", ordinal = 0, argsOnly = true)
    class_2960 fixMissingFromRegistry(@Nullable class_2960 id) {
        if (id != null) {
            // Various MOD_ID renames across mod versions, including Mythic Metals Decorations
            if (id.method_12836().equals("mm_decorations"))
                return class_2960.method_60655("mythicmetals_decorations", id.method_12832());
            if (id.method_12836().equals("mythicaddons") && !id.method_12832().contains("aegis"))
                return class_2960.method_60655("mythicmetals_decorations", id.method_12832());
            if (id.method_12836().equals("mythicaddons") && id.method_12832().contains("aegis"))
                return class_2960.method_60655(MythicMetals.MOD_ID, id.method_12832());
            if (LegacyIds.getLegacyIds().containsKey(id)) return LegacyIds.getLegacyIds().get(id);

        }
        return id;
    }
}
