package com.mythicmetals.mixin;

import com.mythicmetals.ability.Abilities;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import net.minecraft.class_3483;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1890.class)
public class EnchantmentHelperMixin {

    @Inject(method = "getProtectionAmount", at = @At("TAIL"), cancellable = true)
    private static void mythicmetals$damageReduction(class_3218 world, class_1309 user, class_1282 source, CallbackInfoReturnable<Float> cir) {
        // Make sure that there is any gear to check
        if (!user.method_5661().iterator().hasNext()) return;

        var amount = cir.getReturnValue();
        int change = 0;

        for (var gear : user.method_5661()) {
            if (Abilities.BLAST_PROTECTION.getItems().contains(gear.method_7909()) && source.method_48789(class_8103.field_42249)) {
                change += Abilities.BLAST_PROTECTION.getLevel() * 2;
            }

            if (Abilities.BLAST_PADDING.getItems().contains(gear.method_7909()) && source.method_48789(class_8103.field_42249)) {
                change += Abilities.BLAST_PADDING.getLevel() * 2;
            }

            if (Abilities.PROJECTILE_PROTECTION.getItems().contains(gear.method_7909()) && source.method_48789(class_8103.field_42247)) {
                change += Abilities.PROJECTILE_PROTECTION.getLevel() * 2;
            }

            if (Abilities.FEATHER_FALLING.getItems().contains(gear.method_7909()) && source.method_48789(class_8103.field_42250)) {
                change += Abilities.FEATHER_FALLING.getLevel() * 3;
            }

            if (Abilities.FIRE_PROTECTION.getItems().contains(gear.method_7909()) && source.method_48789(class_8103.field_42246)) {
                change += Abilities.FIRE_PROTECTION.getLevel() * 2;
            }
        }

        if (change != 0)
            cir.setReturnValue(amount + change);
    }

    @Inject(method = "getDamage", at = @At("TAIL"), cancellable = true)
    private static void mythicmetals$increaseDamage(class_3218 world, class_1799 stack, class_1297 target, class_1282 damageSource, float baseDamage, CallbackInfoReturnable<Float> cir) {
        var amount = cir.getReturnValue();
        int change = 0;
        if (Abilities.SMITE.getItems().contains(stack.method_7909()) && target.method_5864() != null && target.method_5864().method_20210(class_3483.field_46232)) {
            change += (int) (Abilities.SMITE.getLevel() * 2.5f);
        }
        if (change != 0) {
            cir.setReturnValue(amount + change);
        }
    }

    @Inject(method = "modifyKnockback", at = @At("TAIL"), cancellable = true)
    private static void mythicmetals$increaseKnockback(class_3218 world, class_1799 stack, class_1297 target, class_1282 damageSource, float baseKnockback, CallbackInfoReturnable<Float> cir) {
        var amount = cir.getReturnValue();
        if (Abilities.KNOCKBACK.getItems().contains(stack.method_7909()))
            cir.setReturnValue(amount + Abilities.KNOCKBACK.getLevel());
    }

}
