package com.mythicmetals.mixin;

import D;
import com.mythicmetals.entity.MythicEntityAttributes;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;

@Mixin(class_1671.class)
public abstract class FireworkRocketEntityMixin extends class_1676 {

    @Shadow
    private @Nullable class_1309 shooter;

    /**
     * @author BasiqueEvangelist
     */
    public FireworkRocketEntityMixin(class_1299<? extends class_1671> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyVariable(method = "tick", at = @At("STORE"), ordinal = 1)
    private class_243 mythicmetals$crabVec3D(class_243 vec) {
        if (this.shooter == null) return vec;
        var speedModifier = this.shooter.method_45325(MythicEntityAttributes.ELYTRA_ROCKET_SPEED);

        if (speedModifier == 0) return vec.method_1021(0);
        return vec.method_1021(1 / speedModifier);
    }

    @Redirect(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/math/Vec3d;add(DDD)Lnet/minecraft/util/math/Vec3d;", ordinal = 0))
    private class_243 mythicmetals$increaseRocketSpeed(class_243 velocity, double x, double y, double z) {
        if (this.shooter == null) return velocity;
        var speedModifier = this.shooter.method_45325(MythicEntityAttributes.ELYTRA_ROCKET_SPEED);

        return velocity.method_1021(speedModifier).method_1031(x, y, z);
    }
}
