package com.mythicmetals.mixin;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.PrometheumComponent;
import com.mythicmetals.data.MythicTags;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static com.mythicmetals.component.PrometheumComponent.createOvergrownModifier;
import static com.mythicmetals.component.PrometheumComponent.createOvergrownToughnessModifier;

@Mixin(class_1792.class)
public abstract class ItemMixin {

    @Inject(method = "postProcessComponents", at = @At("HEAD"))
    private void mythicmetals$dynamicAttributeHandler(class_1799 stack, CallbackInfo ci) {
        if (!stack.method_31573(MythicTags.AUTO_REPAIR)) return;
        if (!stack.method_57826(class_9334.field_49636)) return;
        var prometheumComponent = stack.method_57825(MythicDataComponents.PROMETHEUM, PrometheumComponent.DEFAULT);

        // Handle Overgrown modifiers
        // Armor gets armor and toughness. Anything else gets extra damage
        if (prometheumComponent.isOvergrown()) {
            if (stack.method_7909() instanceof class_1738 item) {
                var attributeComponent = item.method_7844();
                var changedComponent = attributeComponent
                    .method_57484(class_5134.field_23724, createOvergrownModifier(stack, 1, item.method_7685()), class_9274.method_59524(item.method_7685()))
                    .method_57484(class_5134.field_23725, createOvergrownToughnessModifier(stack, 0), class_9274.method_59524(item.method_7685()));
                stack.method_57379(class_9334.field_49636, changedComponent);
            }
            else if (stack.method_57826(class_9334.field_49636)) {
                var attributeComponent = stack.method_57824(class_9334.field_49636);
                var modifier = createOvergrownModifier(stack, 0);
                var changedComponent = attributeComponent.method_57484(class_5134.field_23721, modifier, class_9274.field_49217);
                stack.method_57379(class_9334.field_49636, changedComponent);
            }
        }
    }

    @Inject(method = "inventoryTick", at = @At("TAIL"))
    private void mythicmetals$inventoryTick(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected, CallbackInfo ci) {
        if (world.method_8608()) return;

        if (stack.method_57826(MythicDataComponents.PROMETHEUM)) {
            PrometheumComponent.tickAutoRepair(stack, world);
        }
    }
}
