package com.mythicmetals.mixin;

import com.mojang.serialization.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_156;
import net.minecraft.class_9267;

@Mixin(class_9267.class)
public abstract class ItemStackComponentizationFixin {

    @Unique
    private static final Set<String> MM_MIDAS = Set.of(
        "mythicmetals:midas_gold_sword",
        "mythicmetals:gilded_midas_gold_sword"
    );

    @Unique
    private static final Set<String> MM_PROMETHEUM = Set.of(
        "mythicmetals:prometheum_sword",
        "mythicmetals:prometheum_pickaxe",
        "mythicmetals:prometheum_axe",
        "mythicmetals:prometheum_shovel",
        "mythicmetals:prometheum_hoe",
        "mythicmetals:prometheum_helmet",
        "mythicmetals:prometheum_chestplate",
        "mythicmetals:prometheum_leggings",
        "mythicmetals:prometheum_boots"
    );

    private static final Set<String> MM_TIDESINGER = Set.of(
        "mythicmetals:tidesinger_helmet",
        "mythicmetals:tidesinger_chestplate",
        "mythicmetals:tidesinger_leggings",
        "mythicmetals:tidesinger_boots"
    );

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Inject(method = "fixStack", at = @At("TAIL"))
    private static void mythicmetals$migrateToMythicDataComponents(class_9267.class_9268 data, Dynamic dynamic, CallbackInfo ci) {
        if (data.method_57269(MM_MIDAS)) {
            data.method_57263("mythicmetals:gold_folded", dynamic.emptyMap()
                .setFieldIfPresent("gold_folded", data.method_57262("GoldFolded").result())
                .set("is_royal", dynamic.createBoolean(false))
                .set("show_tooltip", dynamic.createBoolean(true))
            );
            data.method_57262("IsRoyal");
            data.method_57262("IsGilded");
        }

        if (data.method_57270("mythicmetals:royal_midas_gold_sword")) {
            data.method_57263("mythicmetals:gold_folded", dynamic.emptyMap()
                .setFieldIfPresent("gold_folded", data.method_57262("GoldFolded").result())
                .set("is_royal", dynamic.createBoolean(true))
                .set("show_tooltip", dynamic.createBoolean(true))
            );
            data.method_57262("IsRoyal");
            data.method_57262("IsGilded");
        }

        if (data.method_57269(MM_PROMETHEUM)) {
            data.method_57263("mythicmetals:prometheum", dynamic.emptyMap()
                .setFieldIfPresent("durability_repaired", data.method_57262("DurabilityRepaired").result())
            );
        }

        if (data.method_57270("mythicmetals:mythril_drill")) {

            var list = class_156.method_654(new ArrayList<Dynamic<?>>(), objects -> {
                objects.add(data.method_57262("UpgradeSlot1").result().orElse(dynamic.emptyMap()));
                objects.add(data.method_57262("UpgradeSlot2").result().orElse(dynamic.emptyMap()));
            });

            data.method_57263("mythicmetals:drill", dynamic.emptyMap()
                .setFieldIfPresent("fuel", data.method_57262("Fuel").result())
            );

            data.method_57263("mythicmetals:upgrades", dynamic.emptyMap()
                .set("size", dynamic.createInt(2))
                .set("items", dynamic.createList(list.stream()))
            );

            data.method_57262("IsActive");
        }

        if (data.method_57269(MM_TIDESINGER)) {
            data.method_57263("mythicmetals:tidesinger", dynamic.emptyMap()
                .setFieldIfPresent("pattern", data.method_57262("mm_coral_type").result())
            );
        }
    }
}
