package com.mythicmetals.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mythicmetals.MythicMetals;
import com.mythicmetals.armor.MythicArmor;
import com.mythicmetals.component.DrillComponent;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.effects.MythicStatusEffects;
import com.mythicmetals.entity.CombustionCooldown;
import com.mythicmetals.entity.MythicEntityAttributes;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.misc.MythicParticleSystem;
import com.mythicmetals.misc.WasSpawnedFromCreeper;
import com.mythicmetals.registry.RegisterCriteria;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9636;
import net.minecraft.entity.*;
import net.minecraft.entity.attribute.*;
import net.minecraft.entity.effect.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

import static com.mythicmetals.entity.MythicEntityAttributes.FIRE_VULNERABILITY;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Shadow
    public abstract Iterable<class_1799> getArmorItems();

    @Shadow
    public abstract boolean method_32316();

    @Shadow
    public abstract int getArmor();

    @Shadow
    public abstract boolean method_5643(class_1282 source, float amount);

    @Shadow
    public abstract boolean addStatusEffect(class_1293 effect);

    @Shadow
    private @Nullable class_1309 attacker;

    @Shadow
    public abstract boolean canHaveStatusEffect(class_1293 effect);

    @Shadow
    public abstract class_1799 getStackInHand(class_1268 hand);

    @Shadow
    public abstract void method_5848();

    @Shadow
    public abstract boolean hasStatusEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract double getAttributeValue(class_6880<class_1320> attribute);

    @Shadow
    public abstract @Nullable class_1293 getStatusEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract boolean removeStatusEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract class_5131 getAttributes();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Unique
    Random r = new Random();

    @Inject(method = "createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;", require = 1, allow = 1, at = @At("RETURN"))
    private static void mythicmetals$addAttributes(final CallbackInfoReturnable<class_5132.class_5133> info) {
        info.getReturnValue().method_26867(MythicEntityAttributes.CARMOT_SHIELD);
        info.getReturnValue().method_26867(FIRE_VULNERABILITY);
        info.getReturnValue().method_26867(MythicEntityAttributes.ELYTRA_ROCKET_SPEED);
    }

    @ModifyExpressionValue(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;hasStatusEffect(Lnet/minecraft/registry/entry/RegistryEntry;)Z"))
    private boolean mythicmetals$bypassFireResistance(boolean original) {
        // We respect Fire Invulnerability, but not Fire Resistance
        // original = source.isFire() && this.hasStatusEffect(StatusEffects.FIRE_RESISTANCE)
        return original && !(this.getAttributeValue(FIRE_VULNERABILITY) > 0);
    }

    /**
     * Increase fire damage taken by 1 for each point of Fire Vulnerability
     * Fire Resistance halves this, although you will still take fire damage this way
     */
    @ModifyVariable(method = "damage", at = @At(value = "HEAD"), argsOnly = true)
    private float mythicmetals$changeFireDamage(float original, class_1282 source) {
        if (!this.getAttributes().method_45331(FIRE_VULNERABILITY) || !source.method_48789(class_8103.field_42246)) {
            return original;
        }

        float baseDamage = (float) this.getAttributeValue(FIRE_VULNERABILITY);
        float modifier = this.hasStatusEffect(class_1294.field_5918) ? Math.min(class_3532.method_15375((baseDamage / 2.0f)), 1) : baseDamage;
        return original + modifier;
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void mythicmetals$tick(CallbackInfo ci) {
        if (!method_37908().method_8608()) {
            mythicmetals$tickCombustion();
        }
        mythicmetals$palladiumParticles();
        mythicmetals$addArmorEffects();
    }

    @Unique
    private void mythicmetals$tickCombustion() {
        var component = getComponent(MythicMetals.COMBUSTION_COOLDOWN);
        component.tickCooldown();
        mythicmetals$handleCombustion(component);
    }

    @Unique
    private void mythicmetals$handleCombustion(CombustionCooldown component) {
        var entry = class_7923.field_41174.method_47983(MythicStatusEffects.HEAT);
        if (this.method_5809() && this.hasStatusEffect(class_7923.field_41174.method_47983(MythicStatusEffects.HEAT)) && component.isCombustible()) {
            var effect = this.getStatusEffect(entry);
            if (effect != null) {
                int level = effect.method_5578();
                int duration = effect.method_5584();
                var multiplier = new AtomicInteger(effect.method_5584());
                this.removeStatusEffect(entry);

                MythicParticleSystem.COMBUSTION_EXPLOSION.spawn(method_37908(), this.method_19538());

                if (this.attacker != null && this.attacker.method_6047() != null) {
                    var stack = this.attacker.method_6047();
                    stack.method_58657().method_57534().forEach(enchantmentRegistryEntry -> {
                        if (enchantmentRegistryEntry.method_40220(class_9636.field_51552)) {
                            multiplier.addAndGet(1);
                        }
                    });
                }

                this.addStatusEffect(new class_1293(class_7923.field_41174.method_47983(MythicStatusEffects.COMBUSTION), multiplier.get() + 40, Math.max(class_3532.method_15375(level / 2.0f), 0), false, true));

                this.method_56073((duration * multiplier.get()) + 40);
                component.setCooldown(1800);
            }

        }
    }

    @Unique
    private void mythicmetals$addArmorEffects() {
        for (class_1799 armorStack : getArmorItems()) {
            // Turns out, this bug was in Minecraft itself
            // It only took a couple of years to find, and it was re-producible in vanilla context
            if (armorStack.method_7960()) continue; // Don't get the item for an empty stack
            if (armorStack.method_7909() == null) {
                MythicMetals.LOGGER.error("An ItemStack was somehow marked as not empty, but it doesn't contain an item.");
                MythicMetals.LOGGER.error("This is not caused by Mythic Metals, and it could potentially crash!");
                MythicMetals.LOGGER.error("Skipping the Armor Item query");
                continue;
            }

            if (MythicArmor.CARMOT.isInArmorSet(armorStack)) {
                mythicmetals$carmotParticle();
            }

            if (MythicArmor.COPPER.isInArmorSet(armorStack) && method_37908().method_8546()) {
                class_243 playerPos = this.method_19538();
                boolean isConductive = playerPos.field_1351 == method_37908().method_8624(class_2902.class_2903.field_13202, (int) playerPos.field_1352, (int) playerPos.field_1350);
                int rng = r.nextInt(60000);

                // Display particles on client
                mythicmetals$copperParticle();

                // Randomly strike the player with lightning when conductive
                if (rng == 666 & isConductive) {
                    class_1538 lightningEntity = class_1299.field_6112.method_5883(method_37908());
                    if (lightningEntity != null) {
                        lightningEntity.method_5719(this);
                        method_37908().method_8649(lightningEntity);
                        this.method_5643(method_37908().method_48963().method_48809(), 10);
                    }
                }
            }
        }
    }

    @Unique
    private void mythicmetals$carmotParticle() {
        if (!this.method_37908().method_8608()) return;
        class_243 velocity = this.method_18798();

        if (this.method_31747() && this.getComponent(MythicMetals.CARMOT_SHIELD).shieldHealth == 0) {
            return; // If you are a player, and your shield ran out, do not display particles
        }

        // Particle trail if the entity is moving
        if (velocity.method_1033() >= 0.1 && r.nextInt(10) < 1) {
            MythicParticleSystem.CARMOT_TRAIL.spawn(method_37908(), this.method_19538());
        }
    }

    @Unique
    private void mythicmetals$copperParticle() {
        if (this.method_37908().method_8608() && r.nextInt(40) < 1) {
            MythicParticleSystem.COPPER_SPARK.spawn(method_37908(), this.method_19538().method_1031(0, 1, 0));
        }
    }

    @Unique
    private void mythicmetals$palladiumParticles() {
        var heatEntry = class_7923.field_41174.method_47983(MythicStatusEffects.HEAT);
        if (this.hasStatusEffect(heatEntry)) {
            var status = this.getStatusEffect(heatEntry);
            if (status == null || status.method_5578() < 3) return;

            class_243 velocity = this.method_18798();
            if (velocity.method_1033() >= 0.1 && r.nextInt(6) < 1) {
                MythicParticleSystem.SMOKING_PALLADIUM_PARTICLE.spawn(method_37908(), this.method_19538().method_1031(0, 0.25, 0));
            }
        }

        if (this.hasStatusEffect(class_7923.field_41174.method_47983(MythicStatusEffects.COMBUSTION))) {
            class_243 velocity = this.method_18798();
            if (velocity.method_1033() >= 0.1 && r.nextInt(6) < 1) {
                MythicParticleSystem.OVERENGINEERED_PALLADIUM_PARTICLE.spawn(method_37908(), this.method_19538().method_1031(0, 0.25, 0));
            }
        }
    }

    /**
     * Bonus advancement if you combust yourself via a creeper. Good job.
     */
    @Inject(method = "addStatusEffect(Lnet/minecraft/entity/effect/StatusEffectInstance;Lnet/minecraft/entity/Entity;)Z", at = @At("HEAD"))
    private void mythicmetals$grantAdvancementOnStatusEffectFromCreepers(class_1293 effect, class_1297 source, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_37908().method_8608() || source == null || !this.canHaveStatusEffect(effect)) return;
        if (effect.method_5579().comp_349().equals(MythicStatusEffects.COMBUSTION) && this.method_31747()) {
            if (source instanceof class_1295 cloudEntity && ((WasSpawnedFromCreeper) cloudEntity).mythicmetals$isSpawnedFromCreeper()) {
                //noinspection ConstantConditions
                RegisterCriteria.RECEIVED_COMBUSTION_FROM_CREEPER.trigger(((class_3222) (Object) this));
            }
        }
    }

    @Environment(EnvType.CLIENT)
    @Inject(method = "swingHand(Lnet/minecraft/util/Hand;Z)V", at = @At("HEAD"), cancellable = true)
    private void mythicmetals$cancelSwingOnActiveMythrilDrill(class_1268 hand, boolean fromServerPlayer, CallbackInfo ci) {
        if (!this.method_37908().method_8608()) {
            return;
        }
        var stack = this.getStackInHand(hand);
        var camera = class_310.method_1551().method_1561().field_4686;
        // This can be null, according to #252
        if (camera == null) return;
        if (camera.method_19333() && stack.method_57825(MythicDataComponents.DRILL, DrillComponent.DEFAULT).hasFuel()) {
            ci.cancel();
        }
    }

    @Inject(method = "dropEquipment", at = @At(value = "HEAD"))
    private void mythicmetals$dropMidasGold(class_3218 world, class_1282 source, boolean causedByPlayer, CallbackInfo ci) {
        if (source.method_5529() == null) return;
        if (source.method_5529() instanceof class_1657 attacker1) {
            if (MythicMetals.CONFIG.midasGold() && attacker1.method_6047().method_31573(MythicTags.MIDAS_TOUCH)) {
                this.method_5775(new class_1799(MythicItems.MIDAS_GOLD.getRawOre()));
            }
        }
    }

    @Inject(method = "tickRiding", at = @At("HEAD"))
    private void mythicmetals$tickRiding(CallbackInfo ci) {
        if (this.method_5765() && this.method_37908().method_8510() % 40 == 1 && this.method_5854().method_5864().method_20210(MythicTags.GRANTS_FIRE_RES_WHILE_RIDING)) {
            this.addStatusEffect(new class_1293(class_1294.field_5918, 120));
        }
    }
}
