package com.mythicmetals.mixin;

import com.mythicmetals.armor.MythicArmorMaterials;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.misc.MythicLootOps;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_4836;
import net.minecraft.class_4838;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.item.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4838.class)
public class PiglinBrainMixin {

    @Unique
    private static class_1799 mythicmetals$cachedBarterItem;

    @Inject(method = "acceptsForBarter", at = @At("HEAD"), cancellable = true)
    private static void acceptMidasGold(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.method_31574(MythicItems.MIDAS_GOLD.getIngot())) {
            cir.setReturnValue(true);
        }
    }

    @Inject(method = "wearsGoldArmor", at = @At("HEAD"), cancellable = true)
    private static void checkForMidasGoldArmor(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        for (class_1799 itemStack : entity.method_5661()) {
            class_1792 item = itemStack.method_7909();
            if (item instanceof class_1738 armorItem && armorItem.method_7686().comp_349() == MythicArmorMaterials.MIDAS_GOLD) {
                cir.setReturnValue(true);
            }
        }
    }

    @Inject(method = "consumeOffHandItem", at = @At("HEAD"))
    private static void mythicmetals$grabBarteredItem(class_4836 piglin, boolean barter, CallbackInfo ci) {
        mythicmetals$cachedBarterItem = piglin.method_6079();
    }

    @ModifyVariable(method = "getBarteredItem", at = @At(value = "LOAD"))
    private static class_52 giveLootForMidasGold(class_52 table, class_4836 piglin) {
        if (mythicmetals$cachedBarterItem.method_31574(MythicItems.MIDAS_GOLD.getIngot()) && piglin.method_37908().method_8503() != null) {
            return piglin.method_37908().method_8503().method_58576().method_58295(class_5321.method_29179(class_7924.field_50079, MythicLootOps.BETTER_PIGLIN_BARTERING));
        }
        return table;
    }

}
