package com.mythicmetals.mixin;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.armor.CarmotShield;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.tools.HammerBase;
import com.mythicmetals.misc.IsAttackCritical;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3445;
import net.minecraft.entity.*;
import net.minecraft.entity.player.*;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements IsAttackCritical {

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Unique
    public boolean mythicmetals$isCritical = false;

    @Shadow
    public abstract class_1661 getInventory();

    @Shadow
    public abstract Iterable<class_1799> method_5661();

    @Shadow
    public abstract void incrementStat(class_3445<?> stat);

    @Shadow
    @Final
    private class_1796 itemCooldownManager;

    @Inject(method = "getBlockBreakingSpeed", at = @At("RETURN"), cancellable = true)
    private void slowBreak(class_2680 blockState, CallbackInfoReturnable<Float> cir) {
        var mainHandStack = getInventory().method_7391();
        float speedMod = 1.0f;

        // Don't do any special handling if you are not holding a tool
        if (mainHandStack.method_7960()) return;

        // Slow down mining MM ores if you are using an item without a high enough mining level
        if (blockState.method_26164(MythicTags.MYTHIC_ORES) && !mainHandStack.method_7951(blockState)) {
            if (mainHandStack.method_7942() && mainHandStack.method_58657().method_57534().iterator().next().equals(class_1893.field_9131)) {
                speedMod *= 0.01f;
            } else {
                speedMod *= 0.3f;
            }

        }

        // Slow down Hammers
        if (mainHandStack.method_7909() instanceof HammerBase) {
            speedMod *= 0.9f;
        }

        if (speedMod < 1.0f) {
            var speed = cir.getReturnValue();
            cir.setReturnValue(speed * speedMod);
        }

    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void tickCarmotShield(CallbackInfo ci) {
        getComponent(MythicMetals.CARMOT_SHIELD).tickShield();
    }

    @ModifyVariable(
        method = "applyDamage",
        at = @At(value = "INVOKE",
            target = "Lnet/minecraft/entity/player/PlayerEntity;applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F",
            shift = At.Shift.BY, by = -2),
        ordinal = 0,
        argsOnly = true)
    public float carmotShieldCancel(float amount) {
        var shield = getComponent(MythicMetals.CARMOT_SHIELD);
        if (shield.getMaxHealth() > 0) {
            float health = shield.shieldHealth;
            shield.damageShield(amount);
            return amount > health ? amount - health : 0;

        }

        return amount;
    }

    @Inject(method = "attack", at = @At("HEAD"))
    private void setMythicmetals$resetCritical(class_1297 target, CallbackInfo ci) {
        mythicmetals$setCritical(false);
    }

    @Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;addCritParticles(Lnet/minecraft/entity/Entity;)V"))
    private void mythicmetals$captureCritical(CallbackInfo ci) {
        mythicmetals$setCritical(true);
    }

    @Override
    public void mythicmetals$setCritical(boolean isCritical) {
        mythicmetals$isCritical = isCritical;
    }

    @Override
    public boolean mythicmetals$isCritical() {
        return mythicmetals$isCritical;
    }
}
