package com.mythicmetals.mixin;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.armor.CarmotShield;
import com.mythicmetals.client.rendering.StormyxShieldRenderer;
import com.mythicmetals.component.DrillComponent;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.client.render.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.mythicmetals.client.rendering.PlayerEnergySwirlFeatureRenderer.SWIRL_TEXTURE;
import static com.mythicmetals.misc.UsefulSingletonForColorUtil.MetalColors.SHIELD_BREAK_COLOR;

@Mixin(class_1007.class)
public class PlayerEntityRendererMixin {
    /**
     * Renders the Carmot Shield on the players arm
     */
    @Inject(method = "renderArm", at = @At("TAIL"))
    private void mythicmetals$renderShieldArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, class_630 arm, class_630 sleeve, CallbackInfo ci) {
        if (player.getComponent(MythicMetals.CARMOT_SHIELD).shouldRenderShield()) {
            final var client = class_310.method_1551();
            float f = player.field_6012 + (client.method_1493() ? 0 : client.method_60646().method_60637(true));

            var shield = player.getComponent(MythicMetals.CARMOT_SHIELD);

            var consumer = vertexConsumers.getBuffer(class_1921.method_23018(SWIRL_TEXTURE, (f * .005f) % 1f, f * .005f % 1f));
            matrices.method_22905(1.0625f, 1.0625f, 1.0625f);
            if (shield.cooldown > CarmotShield.MAX_COOLDOWN - 30) {
                sleeve.method_22699(matrices, consumer, light, class_4608.field_21444, SHIELD_BREAK_COLOR);
            } else // Regular animation
                sleeve.method_22699(matrices, consumer, light, class_4608.field_21444, UsefulSingletonForColorUtil.rainbow());
        }
    }

    /**
     * Renders the Stormyx Shield around the player
     */
    @Inject(method = "render(Lnet/minecraft/client/network/AbstractClientPlayerEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
        at = @At("TAIL"))
    private void mythicmetals$renderRainbowShield(class_742 player, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, CallbackInfo ci) {
        var stack = player.method_6030();
        // Only render if the shield is actively being used
        if (stack.method_7909().equals(MythicTools.STORMYX_SHIELD)) {
            matrixStack.method_22903();
            StormyxShieldRenderer.renderRainbowShield(matrixStack, vertexConsumerProvider, i, player);
            matrixStack.method_22909();
        }
    }

    @Inject(method = "getArmPose", at = @At("RETURN"), cancellable = true)
    private static void mythicmetals$mythrilDrillPose(class_742 player, class_1268 hand, CallbackInfoReturnable<class_572.class_573> cir) {
        var stack = player.method_5998(hand);
        if (stack.method_57825(MythicDataComponents.DRILL, DrillComponent.DEFAULT).hasFuel()) {
            cir.setReturnValue(class_572.class_573.field_3405);
        }
    }
}
