package com.mythicmetals.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.misc.RegistryHelper;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4862;
import net.minecraft.class_4894;
import net.minecraft.class_4895;

@Mixin(class_4895.class)
public abstract class SmithingScreenMixin extends class_4894<class_4862> {

    @Shadow
    @Final
    @Mutable
    private static List<class_2960> EMPTY_SLOT_TEXTURES;

    public SmithingScreenMixin(class_4862 handler, class_1661 playerInventory, class_2561 title, class_2960 texture) {
        super(handler, playerInventory, title, texture);
    }

    @Inject(method = "<clinit>", at = @At("TAIL"))
    private static void mythicmetals$attachMoreTextures(CallbackInfo ci) {
        var list = new ArrayList<>(EMPTY_SLOT_TEXTURES);
        list.add(RegistryHelper.id("item/template/empty_slot_midas_template"));
        list.add(RegistryHelper.id("item/template/empty_slot_crafted_template"));
        EMPTY_SLOT_TEXTURES = list;
    }

    /**
     * Modifies the return value of the Smithing Screen Handler to show the invalid arrow for Mythril Drill Upgrade Recipes.
     * These usually do not have a smithing template, and therefore need an extra check to show the arrow
     * <br>
     * EXPERIMENTAL
     *
     * @param original the check on whether all three slots are filled
     */
    @ModifyReturnValue(method = "hasInvalidRecipe", at = @At("RETURN"))
    private boolean mythicmetals$complainAboutShortUpgradeRecipes(boolean original) {
        if (this.field_2797.method_7611(1).method_7677().method_7909().equals(MythicTools.MYTHRIL_DRILL)) {
            return this.field_2797.method_7611(1).method_7681() && this.field_2797.method_7611(2).method_7681() && !this.field_2797.method_7611(3).method_7681();
        }
        return original;
    }
}
