package com.mythicmetals.mixin;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.UpgradeComponent;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.MythicItems;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_182;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_47;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_182.class)
public class TableBonusLootConditionMixin {

    @Shadow
    @Final
    private class_6880<class_1887> enchantment;

    @ModifyVariable(
        method = "test(Lnet/minecraft/loot/context/LootContext;)Z",
        at = @At(value = "LOAD")
    )
    private int mythicmetals$increaseFortune(int level, class_47 lootCtx) {
        var toolCtxStack = lootCtx.method_296(class_181.field_1229);
        if (toolCtxStack == null) {
            return level;
        }

        if (!this.enchantment.method_40224((enchantmentRegistryKey) -> enchantmentRegistryKey.equals(class_1893.field_9130))) {
            return level;
        }

        if ((toolCtxStack.method_31573(MythicTags.BONUS_FORTUNE))) {
            return level + 1;
        }

        if (toolCtxStack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2)).hasUpgrade(MythicItems.Mats.CARMOT_STONE)) {
            return level + 1;
        }
        return level;
    }
}
