package com.mythicmetals.recipe;

import com.mythicmetals.component.GoldFoldedComponent;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.item.tools.MythicTools;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.EndecRecipeSerializer;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_9697;
import net.minecraft.recipe.*;

import static com.mythicmetals.component.MythicDataComponents.GOLD_FOLDED;

public record MidasFoldingRecipe(class_1856 template, class_1856 base, class_1856 addition,
                                 class_1799 result) implements class_8059 {

    @Override
    public boolean matches(class_9697 input, class_1937 world) {
        // Regular test
        if (!(this.template.method_8093(input.comp_2677()) && this.base.method_8093(input.comp_2678()) && this.addition.method_8093(input.comp_2679()))) {
            return false;
        }
        var stack = input.comp_2678();

        if (!stack.method_57826(GOLD_FOLDED)) return false;
        int goldCount = stack.method_57826(GOLD_FOLDED) ? stack.method_57824(GOLD_FOLDED).goldFolded() : 0;

        if (input.comp_2677().method_7909().equals(MythicItems.Templates.ROYAL_MIDAS_SMITHING_TEMPLATE)) {
            return goldCount >= 640;
        }

        if (stack.method_7909().equals(MythicTools.ROYAL_MIDAS_GOLD_SWORD)) {
            return goldCount >= 640 && goldCount < 10000;
        }

        return goldCount < 640;
    }

    @Override
    public class_1799 craft(class_9697 input, class_7225.class_7874 lookup) {
        var swordInputStack = input.comp_2678().method_7972();

        int goldCount = swordInputStack.method_57824(GOLD_FOLDED).goldFolded();
        swordInputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(goldCount + 1));

        // Gilded Midas Gold Sword handler
        if (swordInputStack.method_7909().equals(MythicTools.GILDED_MIDAS_GOLD_SWORD)) {

            // Transform into Royal Midas Gold Sword
            if (goldCount >= 640) {
                var swordnite = swordInputStack.method_56701(MythicTools.ROYAL_MIDAS_GOLD_SWORD, 1);
                swordnite.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(goldCount + 1, true));
                return swordnite;
            }
        }

        // Handle Midas Gold Sword, transform if you fold and it at least has 320 gold on it
        if (swordInputStack.method_7909().equals(MythicTools.MIDAS_GOLD_SWORD)) {

            // Transform Midas Gold Sword into Gilded Midas Gold Sword
            if (goldCount >= 319) {
                var swordnite = swordInputStack.method_56701(MythicTools.GILDED_MIDAS_GOLD_SWORD, 1);
                swordnite.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(goldCount + 1));
                return swordnite;
            }
        }

        return swordInputStack;
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return this.result;
    }


    @Override
    public class_1865<?> method_8119() {
        return MythicRecipeSerializers.MIDAS_FOLDING_RECIPE;
    }

    @Override
    public boolean method_48453(class_1799 stack) {
        return this.template.method_8093(stack);
    }

    @Override
    public boolean method_48454(class_1799 stack) {
        return this.base.method_8093(stack);
    }

    @Override
    public boolean method_30029(class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public static class Serializer extends EndecRecipeSerializer<MidasFoldingRecipe> {
        private static final StructEndec<MidasFoldingRecipe> ENDEC = StructEndecBuilder.of(
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("template", recipe -> recipe.template),
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("base", recipe -> recipe.base),
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("addition", recipe -> recipe.addition),
            MinecraftEndecs.ITEM_STACK.fieldOf("result", recipe -> recipe.result),
            MidasFoldingRecipe::new
        );

        public Serializer() {
            super(ENDEC);
        }
    }
}
