package com.mythicmetals.recipe;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.TidesingerPatternComponent;
import com.mythicmetals.data.MythicTags;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.EndecRecipeSerializer;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_9697;
import net.minecraft.recipe.*;

public record TidesingerCoralRecipe(class_1856 base, class_1856 addition, class_1856 template,
                                    class_1799 result) implements class_8059 {

    @Override
    public boolean method_48453(class_1799 stack) {
        return this.template.method_8093(stack);
    }

    @Override
    public boolean method_48454(class_1799 stack) {
        return this.base.method_8093(stack);
    }

    @Override
    public boolean method_30029(class_1799 stack) {
        return this.addition.method_8093(stack) && stack.method_31573(MythicTags.TIDESINGER_CORAL);
    }

    @Override
    public boolean matches(class_9697 input, class_1937 world) {
        return this.template.method_8093(input.comp_2677()) && this.base.method_8093(input.comp_2678()) && this.addition.method_8093(input.comp_2679());
    }

    @Override
    public class_1799 craft(class_9697 input, class_7225.class_7874 lookup) {
        var armorStack = input.comp_2678().method_56701(this.result().method_7909(), 1);
        armorStack.method_57379(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.fromStack(input.comp_2679()));
        return armorStack;
    }

    @Override
    public class_1799 method_8110(class_7225.class_7874 lookup) {
        return this.result;
    }

    @Override
    public class_1865<?> method_8119() {
        return MythicRecipeSerializers.TIDESINGER_CORAL_RECIPE;
    }

    public static class Serializer extends EndecRecipeSerializer<TidesingerCoralRecipe> {

        public static final StructEndec<TidesingerCoralRecipe> ENDEC = StructEndecBuilder.of(
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("base", recipe -> recipe.base),
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("addition", recipe -> recipe.addition),
            CodecUtils.toEndec(class_1856.field_46095).fieldOf("template", recipe -> recipe.template),
            MinecraftEndecs.ITEM_STACK.fieldOf("result", recipe -> recipe.result),
            TidesingerCoralRecipe::new
        );

        public Serializer(StructEndec<TidesingerCoralRecipe> endec) {
            super(endec);
        }
    }
}
