/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_173;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1831;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3039;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_52;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_8567;
import nourl.mythicmetals.MythicMetals;
import nourl.mythicmetals.armor.ArmorSet;
import nourl.mythicmetals.armor.MythicArmor;
import nourl.mythicmetals.blocks.BlockSet;
import nourl.mythicmetals.blocks.MythicBlocks;
import nourl.mythicmetals.command.ArmorSetArgumentType;
import nourl.mythicmetals.command.ToolSetArgumentType;
import nourl.mythicmetals.config.MythicOreConfigs;
import nourl.mythicmetals.config.OreConfig;
import nourl.mythicmetals.item.tools.MythicTools;
import nourl.mythicmetals.item.tools.ToolSet;
import nourl.mythicmetals.misc.RegistryHelper;
import nourl.mythicmetals.misc.StringUtilsAtHome;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MythicCommands {
    public static final String ITEM_SCALE = "{ .sized-image style=\"--image-width: 40%;\" }";
    public static final String RECIPE_SCALE = "{ .sized-recipe style=\"--image-width: 40%;\" }";
    public static final String ICON_SCALE = "{ .sized-image style=\"--image-width: 8%;\" }";
    public static final String BR = "<br>\n";

    private MythicCommands() {
    }

    public static void init() {
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("toolset"), ToolSetArgumentType.class, (class_2314)class_2319.method_41999(ToolSetArgumentType::toolSet));
        ArgumentTypeRegistry.registerArgumentType((class_2960)RegistryHelper.id("armorset"), ArmorSetArgumentType.class, (class_2314)class_2319.method_41999(ArmorSetArgumentType::armorSet));
    }

    public static void registerCommands() {
        LiteralCommandNode mythicRoot = ((LiteralArgumentBuilder)class_2170.method_9247((String)"mythicmetals").requires(src -> src.method_9259(2))).build();
        LiteralCommandNode range = class_2170.method_9247((String)"range").build();
        LiteralCommandNode tools = class_2170.method_9247((String)"tools").build();
        LiteralCommandNode armor = class_2170.method_9247((String)"armor").build();
        LiteralCommandNode wiki = class_2170.method_9247((String)"wiki").build();
        LiteralCommandNode armorStand = class_2170.method_9247((String)"armor-stand").build();
        LiteralCommandNode loot = class_2170.method_9247((String)"test-loot-table").build();
        LiteralCommandNode placeBlocks = ((LiteralArgumentBuilder)class_2170.method_9247((String)"place-all-blocks").executes(context -> MythicCommands.placeAllBlocksets((CommandContext<class_2168>)context, Map.of()))).build();
        ArgumentCommandNode rangeType = ((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::dumpType).executes(MythicCommands::dumpAllOreConfigs)).build();
        ArgumentCommandNode exportTools = ((RequiredArgumentBuilder)class_2170.method_9244((String)"toolset", (ArgumentType)ToolSetArgumentType.toolSet()).executes(MythicCommands::exportTools)).build();
        ArgumentCommandNode exportArmor = ((RequiredArgumentBuilder)class_2170.method_9244((String)"armorset", (ArgumentType)ArmorSetArgumentType.armorSet()).executes(MythicCommands::exportArmor)).build();
        ArgumentCommandNode lootTables = ((RequiredArgumentBuilder)class_2170.method_9244((String)"loot_table", (ArgumentType)class_2232.method_9441()).suggests(class_3039.field_13605).then(class_2170.method_9244((String)"rolls", (ArgumentType)IntegerArgumentType.integer()).executes(MythicCommands::testLootTable))).build();
        RequiredArgumentBuilder trimPattern = (RequiredArgumentBuilder)class_2170.method_9244((String)"trim_pattern", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::trimTypes).executes(context -> {
            String matQuery = StringArgumentType.getString((CommandContext)context, (String)"material");
            String trimQuery = StringArgumentType.getString((CommandContext)context, (String)"trim_pattern");
            return MythicCommands.armorStandCommand((CommandContext<class_2168>)context, matQuery, trimQuery);
        });
        ArgumentCommandNode summonTrims = ((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"material", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::armorMaterial).executes(context -> {
            String mat = StringArgumentType.getString((CommandContext)context, (String)"material");
            return MythicCommands.armorStandCommand((CommandContext<class_2168>)context, mat, null);
        })).then((ArgumentBuilder)trimPattern)).build();
        tools.addChild((CommandNode)exportTools);
        armor.addChild((CommandNode)exportArmor);
        wiki.addChild((CommandNode)tools);
        wiki.addChild((CommandNode)armor);
        range.addChild((CommandNode)rangeType);
        loot.addChild((CommandNode)lootTables);
        armorStand.addChild((CommandNode)summonTrims);
        mythicRoot.addChild((CommandNode)range);
        mythicRoot.addChild((CommandNode)wiki);
        mythicRoot.addChild((CommandNode)armorStand);
        mythicRoot.addChild((CommandNode)loot);
        mythicRoot.addChild((CommandNode)placeBlocks);
        CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> dispatcher.getRoot().addChild((CommandNode)mythicRoot));
    }

    public static int placeAllBlocksets(CommandContext<class_2168> context, Map<String, ArrayList<class_2248>> extraBlocks) {
        class_2168 source = (class_2168)context.getSource();
        class_3218 world = source.method_9225();
        AtomicInteger x = new AtomicInteger((int)source.method_9222().field_1352);
        AtomicInteger y = new AtomicInteger((int)source.method_9222().field_1351);
        int z = (int)source.method_9222().field_1350;
        ReflectionUtils.iterateAccessibleStaticFields(MythicBlocks.class, BlockSet.class, (blockSet, name, field) -> {
            y.set((int)source.method_9222().field_1351);
            if (blockSet.getOre() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getOre().method_9564());
            }
            blockSet.getOreVariants().forEach(block -> world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), block.method_9564()));
            if (blockSet.getOreStorageBlock() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getOreStorageBlock().method_9564());
            }
            if (blockSet.getStorageBlock() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getStorageBlock().method_9564());
            }
            if (blockSet.getAnvil() != null) {
                world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), blockSet.getAnvil().method_9564());
            }
            if (extraBlocks.containsKey(name)) {
                ((ArrayList)extraBlocks.get(name)).forEach(extraBlock -> world.method_8501(class_2338.method_49637((double)x.get(), (double)y.getAndIncrement(), (double)z), extraBlock.method_9564()));
            }
            x.incrementAndGet();
        });
        source.method_9226(() -> class_2561.method_43470((String)"Placed all blocksets starting at %s,%s,%s".formatted(source.method_9222().field_1352, source.method_9222().field_1351, source.method_9222().field_1350)), true);
        return 0;
    }

    private static int testLootTable(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        class_2960 lootTableId = class_2232.method_9443(ctx, (String)"loot_table");
        int rolls = IntegerArgumentType.getInteger(ctx, (String)"rolls");
        class_8567 lootContextParameterSet = new class_8567.class_8568(((class_2168)ctx.getSource()).method_9225()).method_51877(class_181.field_1226, (Object)source.method_9228()).method_51874(class_181.field_24424, (Object)source.method_9222()).method_51875(class_173.field_1179);
        class_52 lootTable = source.method_9211().method_3857().getLootTable(lootTableId);
        HashMap<class_1792, Integer> map = new HashMap<class_1792, Integer>();
        for (int i = 0; i < rolls; ++i) {
            ObjectArrayList list = lootTable.method_51878(lootContextParameterSet);
            list.forEach(itemStack -> {
                int count = map.getOrDefault(itemStack.method_7909(), 0);
                map.put(itemStack.method_7909(), itemStack.method_7947() + count);
            });
        }
        map.forEach((item, integer) -> source.method_9226(() -> class_2561.method_43470((String)(String.valueOf(item) + ": " + integer.toString())), false));
        return 0;
    }

    private static int exportArmor(CommandContext<class_2168> context) {
        String name;
        String id;
        ArmorSet armorSet = ArmorSetArgumentType.getArmorSet(context, "armorset");
        class_2168 source = (class_2168)context.getSource();
        StringBuilder output = new StringBuilder();
        String armorMaterial = class_7923.field_41178.method_10221((Object)armorSet.getHelmet()).method_12832().split("_helmet")[0];
        String armorTypeName = StringUtilsAtHome.toProperCase(armorMaterial.replace("_", " ") + " Armor");
        output.append("\n");
        output.append("<center class=tooltip>").append("\n");
        output.append("<h3>**").append(armorTypeName).append("**</h3>").append("\n");
        output.append("![Image of %s model](../assets/armor-models/256/%s.png)".formatted(armorTypeName, armorMaterial + "_256")).append("\n");
        for (class_1738 armor : armorSet.getArmorItems()) {
            id = class_7923.field_41178.method_10221((Object)armor).method_12832();
            name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            int protection = armor.method_7687();
            output.append("\n");
            output.append("<center class=tooltip>").append("\n");
            output.append("<h4>**").append(name).append("**</h4>").append("\n");
            output.append("![Image of %s](../assets/mythicmetals/%s.png)".formatted(name, id)).append(ITEM_SCALE).append(BR);
            for (int i = 1; i < protection; i += 2) {
                output.append("![armor](../assets/icon/full_armor_icon.png)").append(ICON_SCALE).append("\n");
            }
            if ((protection & 1) == 1) {
                output.append("![armor](../assets/icon/half_armor_icon.png)").append(ICON_SCALE).append("\n");
            }
            output.append(BR);
            output.append("+%s Armor".formatted(protection));
            if (armor.method_26353() > 0.0f) {
                output.append(", +%s Toughness".formatted(Float.valueOf(armor.method_26353())));
            }
            output.append(BR);
            if (armor.method_7686().method_24355() > 0.0f) {
                output.append("+%s Knockback Resistance").append(BR);
            }
            output.append("%s Durability".formatted(armor.method_7841())).append(BR);
        }
        output.append("\n").append("===RECIPE===").append("\n");
        for (class_1738 armor : armorSet.getArmorItems()) {
            id = class_7923.field_41178.method_10221((Object)armor).method_12832();
            name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            output.append("![Image of the recipe for %s](../assets/mythicmetals/recipes/armor/%s.png)".formatted(name, id)).append(RECIPE_SCALE).append(BR);
        }
        output.append("\n").append("===RECIPE END===").append("\n");
        MythicMetals.LOGGER.info((CharSequence)output);
        source.method_9226(() -> class_2561.method_43470((String)"Exported armor to wiki format in logs"), false);
        return 0;
    }

    private static int exportTools(CommandContext<class_2168> context) {
        String name;
        String id;
        ToolSet toolset = ToolSetArgumentType.getToolSet(context, "toolset");
        String br = BR;
        class_2168 source = (class_2168)context.getSource();
        StringBuilder output = new StringBuilder();
        ArrayDeque<Integer> damageDeque = new ArrayDeque<Integer>(Arrays.stream(MythicTools.DEFAULT_DAMAGE).boxed().toList());
        Stack<Float> atkSpd = new Stack<Float>();
        atkSpd.addAll(toolset.getAttackSpeed());
        String setName = StringUtilsAtHome.toProperCase(toolset.getSword().method_8022().toString());
        output.append("<center class=tooltip>").append("\n");
        output.append("<h3>**").append(setName).append("**</h3>").append("\n");
        for (class_1831 tool : toolset.get()) {
            id = class_7923.field_41178.method_10221((Object)tool).method_12832();
            name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            output.append("\n");
            output.append("<h4>**").append(name).append("**</h4>").append("\n");
            output.append("![Image of %s](../assets/mythicmetals/%s.png)".formatted(name, id)).append(ITEM_SCALE).append(br);
            output.append("+%s Attack Damage, %s Attack Speed".formatted(Float.valueOf(tool.method_8022().method_8028() + (float)((Integer)damageDeque.pop()).intValue() + 1.0f), BigDecimal.valueOf(4.0f + ((Float)atkSpd.pop()).floatValue()).setScale(1, RoundingMode.HALF_UP).toPlainString())).append(br);
            output.append("%s Durability".formatted(tool.method_7841())).append(br);
        }
        output.append("\n").append("===RECIPE===").append("\n");
        for (class_1831 tool : toolset.get()) {
            id = class_7923.field_41178.method_10221((Object)tool).method_12832();
            name = StringUtilsAtHome.toProperCase(id.replace('_', ' '));
            output.append("![Image of the recipe for %s](../assets/mythicmetals/recipes/tools/%s.png)".formatted(name, id)).append(RECIPE_SCALE).append(BR);
        }
        output.append("\n").append("===RECIPE END===").append("\n");
        MythicMetals.LOGGER.info((CharSequence)output);
        source.method_9226(() -> class_2561.method_43470((String)"Exported tools to wiki format"), false);
        return 0;
    }

    public static boolean summonArmorStandWithTrim(class_1937 world, @Nullable class_8053 trim, ArmorSet armorSet, int x, int z) {
        if (world.field_9236) {
            return false;
        }
        AtomicBoolean success = new AtomicBoolean(true);
        class_1531 armorStand = new class_1531(world, (double)x, (double)(world.method_31600() - 50), (double)z);
        armorSet.getArmorItems().forEach(armorItem -> {
            class_1799 armorStack = new class_1799((class_1935)armorItem);
            if (!armorStack.method_31573(class_3489.field_41890)) {
                success.set(false);
                return;
            }
            if (trim != null) {
                class_8053.method_48429((class_5455)world.method_30349(), (class_1799)armorStack, (class_8053)trim);
            }
            armorStand.method_5673(armorItem.method_7685(), armorStack);
        });
        if (success.get()) {
            world.method_8649((class_1297)armorStand);
        }
        return success.get();
    }

    public static ArrayList<class_8053> getAllArmorTrims(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<class_8053>();
        }
        ArrayList<class_8053> list = new ArrayList<class_8053>();
        world.method_30349().method_30530(class_7924.field_42083).method_40270().forEach(armorMaterialEntry -> world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(new class_8053((class_6880)armorMaterialEntry, (class_6880)armorTrimEntry))));
        return list;
    }

    public static ArrayList<String> getAllTrimPatternStrs(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(((class_8056)armorTrimEntry.comp_349()).comp_1213().method_12832()));
        return list;
    }

    private static CompletableFuture<Suggestions> dumpType(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        suggestion.suggest("console");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> armorMaterial(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> suggestion.suggest(s));
        suggestion.suggest("all");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> trimTypes(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        ArrayList<class_8056> list = new ArrayList<class_8056>();
        ((class_2168)ctx.getSource()).method_30497().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add((class_8056)armorTrimEntry.comp_349()));
        list.forEach(trimPattern -> suggestion.suggest(trimPattern.comp_1213().method_12832()));
        suggestion.suggest("all").suggest("none");
        return suggestion.buildFuture();
    }

    private static int dumpAllOreConfigs(CommandContext<class_2168> context) {
        if (StringArgumentType.getString(context, (String)"type").equals("console")) {
            ReflectionUtils.iterateAccessibleStaticFields(MythicOreConfigs.class, OreConfig.class, (feature, name, field) -> {
                if (!feature.offset && !feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + " to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.offset) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + "(offset) to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
                if (feature.trapezoid) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has a triangle range between " + feature.bottom + " to " + feature.top + ", where the sweet spot is at Y = " + (feature.bottom + feature.top) / 2 + " with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                }
            });
            return 1;
        }
        return -1;
    }

    private static int armorStandCommand(CommandContext<class_2168> context, @NotNull String material, @Nullable String rawTrim) {
        String trimQuery;
        ArrayList<Object> armorTrims = new ArrayList();
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_243 pos = ((class_2168)context.getSource()).method_9222();
        String string = trimQuery = rawTrim == null ? "none" : rawTrim;
        if (trimQuery.equals("none")) {
            if (material.equals("all")) {
                int x = (int)pos.field_1352;
                int count = 0;
                TreeSet<String> armorSetStrings = new TreeSet<String>(MythicArmor.ARMOR_MAP.keySet());
                for (String armorSetName : armorSetStrings) {
                    if (!MythicCommands.summonArmorStandWithTrim((class_1937)world, null, MythicArmor.ARMOR_MAP.get(armorSetName), x, 0)) continue;
                    ++x;
                    ++count;
                }
                int finalCount = count;
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping %d armorstands".formatted(finalCount)), true);
                return finalCount;
            }
            if (MythicCommands.summonArmorStandWithTrim((class_1937)world, null, MythicArmor.ARMOR_MAP.get(material), (int)pos.field_1352, (int)pos.field_1350)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping one armorstand"), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to summon the armor stand. It might be untrimmable"), false);
            return -1;
        }
        if (material.equals("all")) {
            if (MythicArmor.ARMOR_MAP.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to summon. Somehow the armor map is empty..."), false);
                return -1;
            }
            if (trimQuery.equals("all")) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().toList());
            } else if (MythicCommands.getAllTrimPatternStrs((class_1937)world).contains(trimQuery)) {
                armorTrims.addAll(MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList());
            }
            MutableInt mutX = new MutableInt((Number)pos.field_1352);
            MutableInt mutZ = new MutableInt((Number)pos.field_1350);
            MutableInt count = new MutableInt(0);
            TreeSet<String> armorSetStrings = new TreeSet<String>(MythicArmor.ARMOR_MAP.keySet());
            for (String armorSetName : armorSetStrings) {
                armorTrims.forEach((Consumer<Object>)((Consumer<class_8053>)armorTrim -> {
                    if (MythicCommands.summonArmorStandWithTrim((class_1937)world, armorTrim, MythicArmor.ARMOR_MAP.get(armorSetName), mutX.getValue(), mutZ.getValue())) {
                        mutX.increment();
                        count.increment();
                    }
                }));
                mutZ.increment();
                mutX.setValue(0);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Summoned and dropping %d armorstands with trims".formatted(count.getValue())), true);
            return count.getValue();
        }
        if (MythicArmor.ARMOR_MAP.get(material) != null) {
            if (trimQuery.equals("all")) {
                armorTrims = MythicCommands.getAllArmorTrims((class_1937)world);
            } else {
                List<class_8053> trims = MythicCommands.getAllArmorTrims((class_1937)world).stream().filter(trim -> ((class_8056)trim.method_48424().comp_349()).comp_1213().method_12832().equals(trimQuery)).toList();
                armorTrims.addAll(trims);
            }
            int splitPoint = armorTrims.size() / world.method_30349().method_30530(class_7924.field_42083).method_10204();
            int xOffset = 0;
            int zOffset = 0;
            int count = 0;
            for (int i = 0; i < armorTrims.size(); ++i) {
                if (i % splitPoint == 0) {
                    xOffset += 2;
                    zOffset = 0;
                }
                ArmorSet armorSet = MythicArmor.ARMOR_MAP.get(material);
                if (MythicCommands.summonArmorStandWithTrim((class_1937)world, (class_8053)armorTrims.get(i), armorSet, (int)pos.field_1352 + xOffset, (int)pos.field_1350 + zOffset)) {
                    ++count;
                    zOffset += 2;
                    continue;
                }
                xOffset -= 2;
            }
            String feedback = "Summoned and dropping %d armorstands".formatted(count);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)feedback), true);
            return count;
        }
        return -1;
    }
}

