/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.blocks;

import com.gedrite.blocks.custom.GedritedWaterCauldronBlock;
import com.gedrite.fluids.ModFluids;
import com.gedrite.items.ModItems;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"gedrite");
    public static final DeferredBlock<Block> GEDRITE_BLOCK = ModBlocks.registerBlock("gedrite_block", properties -> new ColoredFallingBlock(new ColorRGBA(15280585), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).speedFactor(0.6f).jumpFactor(0.75f).sound(SoundType.HONEY_BLOCK).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrite_block")))));
    public static final DeferredBlock<Block> RAW_GEDRITE_BLOCK = ModBlocks.registerBlock("raw_gedrite_block", properties -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.CORAL_BLOCK).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"raw_gedrite_block")))));
    public static final DeferredBlock<Block> GEDRITE_ORE = ModBlocks.registerBlock("gedrite_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrite_ore")))));
    public static final DeferredBlock<Block> DEEPSLATE_GEDRITE_ORE = ModBlocks.registerBlock("deepslate_gedrite_ore", properties -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"deepslate_gedrite_ore")))));
    public static final DeferredBlock<LiquidBlock> GEDRITED_WATER_BLOCK = ModBlocks.registerBlock("gedrited_water_block", properties -> new LiquidBlock((FlowingFluid)ModFluids.SOURCE_GEDRITED_WATER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrited_water_block")))));
    public static final DeferredBlock<Block> GEDRITED_WATER_CAULDRON = ModBlocks.registerBlock("gedrited_water_cauldron", properties -> new GedritedWaterCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrited_water_cauldron")))));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> function) {
        DeferredBlock toReturn = BLOCKS.registerBlock(name, function);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.registerItem(name, properties -> new BlockItem((Block)block.get(), properties.useBlockDescriptionPrefix()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

