/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.mixins;

import com.gedrite.fluids.ModFluidTypes;
import com.gedrite.fluids.ModFluids;
import com.gedrite.util.ModTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void gedrite$baseTick(CallbackInfo ci) {
        Predicate<FluidState> isGW;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof LivingEntity && livingEntity.isAlive() && LivingEntityMixin.updateMovementInFluid(livingEntity, isGW = state -> state.isSource() && state.getType().isSame((Fluid)ModFluids.SOURCE_GEDRITED_WATER.get()) || !state.isSource() && state.getType().isSame((Fluid)ModFluids.FLOWING_GEDRITED_WATER.get()))) {
            ModFluids.decayEffect(livingEntity);
        }
    }

    @Unique
    private static boolean updateMovementInFluid(LivingEntity entity, Predicate<FluidState> shouldUpdate) {
        entity.updateFluidHeightAndDoFluidPushing(false);
        return entity.isInFluidType((FluidType)ModFluidTypes.GEDRITED_WATER_FLUID_TYPE.get());
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    private void gedrite$travel(Vec3 pTravelVector, CallbackInfo ci) {
        block7: {
            Vec3 vec35;
            boolean bl;
            double d0;
            LivingEntity entity;
            block8: {
                entity = (LivingEntity)this;
                if (!entity.isLocalInstanceAuthoritative()) break block7;
                d0 = entity.getGravity();
                bl = entity.getDeltaMovement().y <= 0.0;
                boolean flag = bl;
                if (bl && entity.hasEffect(MobEffects.SLOW_FALLING)) {
                    d0 = Math.min(d0, 0.01);
                }
                BlockPos pos = entity.blockPosition();
                FluidState fluidState = entity.level().getFluidState(pos);
                if (fluidState.getFluidType() != ModFluidTypes.GEDRITED_WATER_FLUID_TYPE.get() || !entity.isAffectedByPotions() || entity.canStandOnFluid(fluidState)) break block7;
                if (!(entity instanceof Player)) break block8;
                Player player = (Player)entity;
                if (player.getAbilities().flying) break block7;
            }
            double d9 = entity.getY();
            if (entity.getFluidHeight(ModTags.Fluids.GEDRITED_WATER) <= entity.getFluidJumpThreshold()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.7, 0.9, 0.7));
                vec35 = entity.getFluidFallingAdjustedMovement(d0, bl, entity.getDeltaMovement());
                entity.setDeltaMovement(vec35);
            } else {
                entity.setDeltaMovement(entity.getDeltaMovement().scale(0.7));
            }
            vec35 = entity.getDeltaMovement();
            if (entity.horizontalCollision && entity.isFree(vec35.x, vec35.y + (double)0.6f - entity.getY() + d9, vec35.z)) {
                entity.setDeltaMovement(vec35.x, (double)0.3f, vec35.z);
            }
        }
    }
}

