/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.world.effects;

import com.gedrite.entity.damage.ModDamageTypes;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DecayEffect
extends MobEffect {
    private final Random random = new Random();

    protected DecayEffect(MobEffectCategory type, int color, ParticleOptions particle) {
        super(type, color, particle);
    }

    public boolean applyEffectTick(@NotNull ServerLevel level, LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide() && this.random.nextFloat() < 0.2f) {
            entity.hurt(ModDamageTypes.of((Level)level, ModDamageTypes.DECAY), (float)(this.random.nextInt(4) + 1));
        }
        super.applyEffectTick(level, entity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

