/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite;

import com.gedrite.Config;
import com.gedrite.blocks.ModBlocks;
import com.gedrite.client.renderer.entity.GedriteArrowRenderer;
import com.gedrite.core.cauldron.ModCauldronInteraction;
import com.gedrite.core.dispenser.ModDispenserItemBehavior;
import com.gedrite.core.particles.ModParticles;
import com.gedrite.event.ModEventBus;
import com.gedrite.fluids.ModFluidTypes;
import com.gedrite.fluids.ModFluids;
import com.gedrite.items.ModCreativeModTabs;
import com.gedrite.items.ModItems;
import com.gedrite.sounds.ModSoundEvents;
import com.gedrite.world.effects.ModEffects;
import com.gedrite.world.entity.ModEntities;
import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="gedrite")
public class Gedrite {
    public static final String MOD_ID = "gedrite";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Gedrite(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(Gedrite::commonSetup);
        BuildCreativeModeTabContentsEvent.getBus((BusGroup)modBusGroup).addListener(Gedrite::addCreative);
        RegisterParticleProvidersEvent.getBus((BusGroup)modBusGroup).addListener(ModEventBus::registerParticleFactories);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        ModItems.register(modBusGroup);
        ModBlocks.register(modBusGroup);
        ModCreativeModTabs.register(modBusGroup);
        ModFluids.register(modBusGroup);
        ModFluidTypes.register(modBusGroup);
        ModEffects.register(modBusGroup);
        ModParticles.register(modBusGroup);
        ModSoundEvents.register(modBusGroup);
        ModEntities.register(modBusGroup);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModCauldronInteraction.registerBehavior();
            ModDispenserItemBehavior.registerBehavior();
        });
    }

    private static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(ModItems.GEDRITE_INGOT);
            event.accept(ModItems.RAW_GEDRITE);
            event.accept(ModItems.GEDRITED_COAL);
        }
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept(ModItems.GEDRITE_INGOT);
        }
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.METAL_DETECTOR);
            event.accept(ModItems.GEDRITED_WATER_BUCKET);
        }
        if (event.getTabKey() == CreativeModeTabs.COMBAT) {
            event.accept(ModItems.GEDRITE_ARROW);
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept(ModBlocks.GEDRITE_BLOCK);
        }
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.accept(ModBlocks.RAW_GEDRITE_BLOCK);
            event.accept(ModBlocks.GEDRITE_ORE);
            event.accept(ModBlocks.DEEPSLATE_GEDRITE_ORE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="gedrite", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SOURCE_GEDRITED_WATER.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.FLOWING_GEDRITED_WATER.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT);
            EntityRenderers.register(ModEntities.GEDRITE_ARROW.get(), GedriteArrowRenderer::new);
        }
    }
}

