/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.blocks;

import com.gedrite.blocks.custom.GedritedWaterCauldronBlock;
import com.gedrite.fluids.ModFluids;
import com.gedrite.items.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"gedrite");
    public static final RegistryObject<Block> GEDRITE_BLOCK = ModBlocks.registerBlock("gedrite_block", () -> new ColoredFallingBlock(new ColorRGBA(15280585), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).speedFactor(0.6f).jumpFactor(0.75f).sound(SoundType.HONEY_BLOCK).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrite_block")))));
    public static final RegistryObject<Block> RAW_GEDRITE_BLOCK = ModBlocks.registerBlock("raw_gedrite_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.CORAL_BLOCK).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"raw_gedrite_block")))));
    public static final RegistryObject<Block> GEDRITE_ORE = ModBlocks.registerBlock("gedrite_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrite_ore")))));
    public static final RegistryObject<Block> DEEPSLATE_GEDRITE_ORE = ModBlocks.registerBlock("deepslate_gedrite_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_IRON_ORE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"deepslate_gedrite_ore")))));
    public static final RegistryObject<LiquidBlock> GEDRITED_WATER_BLOCK = ModBlocks.registerBlock("gedrited_water_block", () -> new LiquidBlock(ModFluids.SOURCE_GEDRITED_WATER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrited_water_block")))));
    public static final RegistryObject<Block> GEDRITED_WATER_CAULDRON = ModBlocks.registerBlock("gedrited_water_cauldron", () -> new GedritedWaterCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"gedrited_water_cauldron")))));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)name)))));
    }

    public static void register(BusGroup eventBus) {
        BLOCKS.register(eventBus);
    }
}

