/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.fluids;

import com.gedrite.util.ModTags;
import com.gedrite.world.effects.ModEffects;
import com.gedrite.world.level.material.GedritedWaterFluid;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"gedrite");
    public static final RegistryObject<FlowingFluid> SOURCE_GEDRITED_WATER = FLUIDS.register("gedrited_water_still", GedritedWaterFluid.Source::new);
    public static final RegistryObject<FlowingFluid> FLOWING_GEDRITED_WATER = FLUIDS.register("gedrited_water_flow", GedritedWaterFluid.Flowing::new);

    public static boolean isGedritedWater(FluidState state) {
        return state.is((Fluid)SOURCE_GEDRITED_WATER.get()) || state.is((Fluid)FLOWING_GEDRITED_WATER.get());
    }

    public static boolean isTouchingGedritedWater(LivingEntity entity) {
        return entity.updateFluidHeightAndDoFluidPushing(ModTags.Fluids.GEDRITED_WATER, 0.014);
    }

    public static void decayEffect(LivingEntity entity) {
        if (!entity.hasEffect((Holder)ModEffects.DECAY.getHolder().get())) {
            entity.addEffect(new MobEffectInstance((Holder)ModEffects.DECAY.getHolder().get(), 60, 0, false, false, true));
        }
    }

    public static void register(BusGroup busGroup) {
        FLUIDS.register(busGroup);
    }
}

