/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.mixins;

import com.gedrite.fluids.ModFluidTypes;
import com.gedrite.util.ModTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public class FishingHookMixin {
    @Inject(method={"shouldStopFishing"}, at={@At(value="HEAD")}, cancellable=true)
    private void gedrite$removeIfInvalid(Player player, CallbackInfoReturnable<Boolean> cir) {
        FishingHook hook = (FishingHook)this;
        BlockPos blockpos = hook.blockPosition();
        FluidState fluidstate = hook.level().getFluidState(blockpos);
        if (hook.updateFluidHeightAndDoFluidPushing(ModTags.Fluids.GEDRITED_WATER, 0.014)) {
            hook.discard();
            cir.setReturnValue((Object)true);
        }
    }

    @Unique
    private static boolean updateMovementInFluid(Entity entity, Predicate<FluidState> shouldUpdate) {
        entity.updateFluidHeightAndDoFluidPushing(shouldUpdate);
        return entity.isInFluidType((FluidType)ModFluidTypes.GEDRITED_WATER_FLUID_TYPE.get());
    }
}

