/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.world.entity.projectile;

import com.gedrite.core.particles.ModParticles;
import com.gedrite.items.ModItems;
import com.gedrite.world.effects.ModEffects;
import com.gedrite.world.entity.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class GedriteArrow
extends AbstractArrow {
    private int duration = 60;

    public GedriteArrow(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public GedriteArrow(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.GEDRITE_ARROW.get(), owner, level, pickupItemStack, firedFromWeapon);
    }

    public GedriteArrow(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super(ModEntities.GEDRITE_ARROW.get(), x, y, z, level, pickupItemStack, firedFromWeapon);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide() && !this.isInGround()) {
            this.level().addParticle((ParticleOptions)ModParticles.DECAY_PARTICLE.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        MobEffectInstance mobeffectinstance = new MobEffectInstance((Holder)ModEffects.DECAY.getHolder().get(), this.duration);
        living.addEffect(mobeffectinstance, this.getEffectSource());
    }

    protected void readAdditionalSaveData(ValueInput p_421509_) {
        super.readAdditionalSaveData(p_421509_);
        this.duration = p_421509_.getIntOr("Duration", 200);
    }

    protected void addAdditionalSaveData(ValueOutput p_422688_) {
        super.addAdditionalSaveData(p_422688_);
        p_422688_.putInt("Duration", this.duration);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ModItems.GEDRITE_ARROW.get());
    }
}

