/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.client.particle;

import com.gedrite.core.particles.ModParticles;
import com.gedrite.fluids.ModFluids;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModDripParticle
extends TextureSheetParticle {
    private final Fluid type;

    protected ModDripParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, SpriteSet spriteSet) {
        super(pLevel, pX, pY, pZ);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.type = pType;
        this.pickSprite(spriteSet);
    }

    public static TextureSheetParticle createGedritedWaterHangParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet spriteSet) {
        DripHangParticle particle = new DripHangParticle(pLevel, pX, pY, pZ, (Fluid)ModFluids.SOURCE_GEDRITED_WATER.get(), (ParticleOptions)ModParticles.FALLING_GEDRITED_WATER.get(), spriteSet);
        particle.setColor(0.5294118f, 0.13333334f, 0.4f);
        return particle;
    }

    public static TextureSheetParticle createGedritedWaterFallParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet spriteSet) {
        FallingParticle.FallAndLandParticle particle = new FallingParticle.FallAndLandParticle(pLevel, pX, pY, pZ, (Fluid)ModFluids.SOURCE_GEDRITED_WATER.get(), (ParticleOptions)ModParticles.LANDING_GEDRITED_WATER.get(), spriteSet);
        particle.setColor(0.5294118f, 0.13333334f, 0.4f);
        return particle;
    }

    public static TextureSheetParticle createGedritedWaterLandParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet spriteSet) {
        DripLandParticle particle = new DripLandParticle(pLevel, pX, pY, pZ, (Fluid)ModFluids.SOURCE_GEDRITED_WATER.get(), spriteSet);
        particle.setColor(0.5294118f, 0.13333334f, 0.4f);
        return particle;
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                BlockPos blockpos;
                FluidState fluidstate;
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                if (this.type != Fluids.EMPTY && (fluidstate = this.level.getFluidState(blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z))).getType() == this.type && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripHangParticle
    extends ModDripParticle {
        private final ParticleOptions fallingParticle;

        DripHangParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, ParticleOptions pFallingParticle, SpriteSet spriteSet) {
            super(pLevel, pX, pY, pZ, pType, spriteSet);
            this.fallingParticle = pFallingParticle;
            this.gravity *= 0.02f;
            this.lifetime = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.lifetime-- <= 0) {
                this.remove();
                this.level.addParticle(this.fallingParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingParticle
    extends ModDripParticle {
        FallingParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, SpriteSet spriteSet) {
            this(pLevel, pX, pY, pZ, pType, (int)(64.0 / (Math.random() * 0.8 + 0.2)), spriteSet);
        }

        FallingParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, int pLifetime, SpriteSet spriteSet) {
            super(pLevel, pX, pY, pZ, pType, spriteSet);
            this.lifetime = pLifetime;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        static class FallAndLandParticle
        extends FallingParticle {
            protected final ParticleOptions landParticle;

            FallAndLandParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, ParticleOptions pLandParticle, SpriteSet spriteSet) {
                super(pLevel, pX, pY, pZ, pType, spriteSet);
                this.landParticle = pLandParticle;
            }

            @Override
            protected void postMoveUpdate() {
                if (this.onGround) {
                    this.remove();
                    this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DripLandParticle
    extends ModDripParticle {
        DripLandParticle(ClientLevel pLevel, double pX, double pY, double pZ, Fluid pType, SpriteSet spriteSet) {
            super(pLevel, pX, pY, pZ, pType, spriteSet);
            this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }
}

