/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.fluids;

import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BasicFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation overlayTexture;
    private final int tintColor;
    private final Vector3f fogColor;

    public BasicFluidType(ResourceLocation stillTexture, ResourceLocation flowingTexture, ResourceLocation overlayTexture, int tintColor, Vector3f fogColor, FluidType.Properties properties) {
        super(properties);
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.overlayTexture = overlayTexture;
        this.tintColor = tintColor;
        this.fogColor = fogColor;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public ResourceLocation getOverlayTexure() {
        return this.overlayTexture;
    }

    public Vector3f getFogColor() {
        return this.fogColor;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return BasicFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return BasicFluidType.this.flowingTexture;
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return BasicFluidType.this.overlayTexture;
            }

            public int getTintColor() {
                return BasicFluidType.this.tintColor;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return BasicFluidType.this.fogColor;
            }
        });
    }
}

