/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.mixins;

import com.gedrite.blocks.ModBlocks;
import com.gedrite.fluids.GedritedWaterInteraction;
import com.gedrite.fluids.ModFluidTypes;
import com.gedrite.fluids.ModFluids;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidInteractionRegistry.class})
public class FluidInteractionRegistryMixin {
    @Unique
    private static final Map<FluidType, List<GedritedWaterInteraction>> INTERACTIONS = new HashMap<FluidType, List<GedritedWaterInteraction>>();

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")}, cancellable=true)
    private static void gedrite$static(CallbackInfo ci) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.LAVA_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ModFluidTypes.GEDRITED_WATER_FLUID_TYPE.get(), fluidState -> fluidState.isSource() ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.SOUL_SAND.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.WATER_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)FluidInteractionRegistryMixin.GedritedWaterInteraction((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).is((Fluid)ModFluids.FLOWING_GEDRITED_WATER.get()) || level.getFluidState(relativePos).is((Fluid)ModFluids.SOURCE_GEDRITED_WATER.get()), Blocks.COARSE_DIRT.defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)NeoForgeMod.WATER_TYPE.value()), (FluidInteractionRegistry.InteractionInformation)FluidInteractionRegistryMixin.GedriteInteraction((level, currentPos, relativePos, currentState) -> level.getBlockState(relativePos).is((Block)ModBlocks.GEDRITE_BLOCK.get()) && currentState.isSource(), ((FlowingFluid)ModFluids.SOURCE_GEDRITED_WATER.get()).defaultFluidState().createLegacyBlock()));
        ci.cancel();
    }

    @Unique
    private static FluidInteractionRegistry.InteractionInformation GedritedWaterInteraction(FluidInteractionRegistry.HasFluidInteraction predicate, BlockState state) {
        return FluidInteractionRegistryMixin.GedritedWaterInteraction(predicate, (FluidState fluidState) -> state);
    }

    @Unique
    private FluidInteractionRegistry.InteractionInformation GedritedWaterInteraction(FluidType type, Function<FluidState, BlockState> getState) {
        return FluidInteractionRegistryMixin.GedritedWaterInteraction((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == type, getState);
    }

    @Unique
    private static FluidInteractionRegistry.InteractionInformation GedritedWaterInteraction(FluidInteractionRegistry.HasFluidInteraction predicate, Function<FluidState, BlockState> getState) {
        return new FluidInteractionRegistry.InteractionInformation(predicate, (level, currentPos, relativePos, currentState) -> {
            FluidInteractionRegistryMixin.pssh((LevelAccessor)level, currentPos);
            level.setBlockAndUpdate(currentPos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)currentPos, (BlockPos)currentPos, (BlockState)((BlockState)getState.apply(currentState))));
        });
    }

    @Unique
    private static FluidInteractionRegistry.InteractionInformation GedriteInteraction(FluidInteractionRegistry.HasFluidInteraction predicate, BlockState state) {
        return FluidInteractionRegistryMixin.GedriteInteraction(predicate, (FluidState fluidState) -> state);
    }

    @Unique
    private FluidInteractionRegistry.InteractionInformation GedriteInteraction(FluidType type, Function<FluidState, BlockState> getState) {
        return FluidInteractionRegistryMixin.GedriteInteraction((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == type, getState);
    }

    @Unique
    private static FluidInteractionRegistry.InteractionInformation GedriteInteraction(FluidInteractionRegistry.HasFluidInteraction predicate, Function<FluidState, BlockState> getState) {
        return new FluidInteractionRegistry.InteractionInformation(predicate, (level, currentPos, relativePos, currentState) -> level.setBlockAndUpdate(currentPos, EventHooks.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)currentPos, (BlockPos)currentPos, (BlockState)((BlockState)getState.apply(currentState)))));
    }

    @Unique
    private static synchronized void addModInteraction(FluidType source, GedritedWaterInteraction interaction) {
        INTERACTIONS.computeIfAbsent(source, s -> new ArrayList()).add(interaction);
    }

    @Unique
    private static void fizz(LevelAccessor level, BlockPos pos) {
        level.levelEvent(1501, pos, 0);
    }

    @Unique
    private static void pssh(LevelAccessor level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

