/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.core.cauldron;

import com.gedrite.blocks.ModBlocks;
import com.gedrite.items.ModItems;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public interface ModCauldronInteraction {
    public static final CauldronInteraction.InteractionMap GEDRITED_WATER = CauldronInteraction.newInteractionMap((String)"gedrited_water");

    private static boolean isUnderWater(Level level, BlockPos blockPos) {
        FluidState fluidstate = level.getFluidState(blockPos.above());
        return fluidstate.is(FluidTags.WATER);
    }

    private static InteractionResult fillWaterInteraction(BlockState p_363465_, Level blockState, BlockPos blockPos, Player player, InteractionHand hand, ItemStack stack) {
        return CauldronInteraction.emptyBucket((Level)blockState, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.BUCKET_EMPTY);
    }

    private static InteractionResult fillGedritedWaterInteraction(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack stack) {
        return ModCauldronInteraction.isUnderWater(level, blockPos) ? InteractionResult.CONSUME : CauldronInteraction.emptyBucket((Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((Block)ModBlocks.GEDRITED_WATER_CAULDRON.get()).defaultBlockState(), (SoundEvent)SoundEvents.BUCKET_EMPTY);
    }

    private static InteractionResult fillLavaInteraction(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack stack) {
        return ModCauldronInteraction.isUnderWater(level, blockPos) ? InteractionResult.CONSUME : CauldronInteraction.emptyBucket((Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)Blocks.LAVA_CAULDRON.defaultBlockState(), (SoundEvent)SoundEvents.BUCKET_EMPTY_LAVA);
    }

    private static InteractionResult fillPowderSnowInteraction(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack stack) {
        return ModCauldronInteraction.isUnderWater(level, blockPos) ? InteractionResult.CONSUME : CauldronInteraction.emptyBucket((Level)level, (BlockPos)blockPos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)Blocks.POWDER_SNOW_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3))), (SoundEvent)SoundEvents.BUCKET_EMPTY_POWDER_SNOW);
    }

    public static void registerBehavior() {
        Map mapE = CauldronInteraction.EMPTY.map();
        Map mapW = CauldronInteraction.WATER.map();
        Map mapL = CauldronInteraction.LAVA.map();
        Map mapS = CauldronInteraction.POWDER_SNOW.map();
        Map mapGW = GEDRITED_WATER.map();
        mapGW.put(Items.BUCKET, (state, world, pos, player, hand, stack) -> CauldronInteraction.fillBucket((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.GEDRITED_WATER_BUCKET.get()), statex -> true, (SoundEvent)SoundEvents.BUCKET_FILL));
        mapE.put((Item)ModItems.GEDRITED_WATER_BUCKET.get(), ModCauldronInteraction::fillGedritedWaterInteraction);
        mapL.put((Item)ModItems.GEDRITED_WATER_BUCKET.get(), ModCauldronInteraction::fillGedritedWaterInteraction);
        mapW.put((Item)ModItems.GEDRITED_WATER_BUCKET.get(), ModCauldronInteraction::fillGedritedWaterInteraction);
        mapS.put((Item)ModItems.GEDRITED_WATER_BUCKET.get(), ModCauldronInteraction::fillGedritedWaterInteraction);
        mapGW.put((Item)ModItems.GEDRITED_WATER_BUCKET.get(), ModCauldronInteraction::fillGedritedWaterInteraction);
        mapGW.put(Items.WATER_BUCKET, ModCauldronInteraction::fillWaterInteraction);
        mapGW.put(Items.LAVA_BUCKET, ModCauldronInteraction::fillLavaInteraction);
        mapGW.put(Items.POWDER_SNOW_BUCKET, ModCauldronInteraction::fillPowderSnowInteraction);
        mapGW.put(Items.ARROW, (state, world, pos, player, hand, stack) -> {
            if (world.isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            int arrowsInHand = stack.getCount();
            int arrowsToConvert = Math.min(arrowsInHand, 5);
            if (!player.isCreative()) {
                stack.shrink(arrowsToConvert - 1);
            }
            return CauldronInteraction.fillBucket((BlockState)state, (Level)world, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ModItems.GEDRITE_ARROW.get(), arrowsToConvert), statex -> true, (SoundEvent)SoundEvents.CANDLE_EXTINGUISH);
        });
    }
}

