/*
 * Decompiled with CFR 0.152.
 */
package com.gedrite.fluids;

import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.FogEnvironment;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class ModFluidTypes {
    public static final ResourceLocation GEDRITED_WATER_STILL_RL = ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"block/gedrited_water_still");
    public static final ResourceLocation GEDRITED_WATER_FLOWING_RL = ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"block/gedrited_water_flow");
    public static final ResourceLocation GEDRITED_WATER_OVERLAY_RL = ResourceLocation.fromNamespaceAndPath((String)"gedrite", (String)"misc/in_gedrited_water");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"gedrite");
    public static final DeferredHolder<FluidType, FluidType> GEDRITED_WATER_FLUID_TYPE = FLUID_TYPES.register("gedrited_water", () -> new FluidType(FluidType.Properties.create().canSwim(false).canDrown(false).motionScale(0.003).supportsBoating(false).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH)));
    public static final DeferredHolder<FluidType, FluidType> TEST_FLUID_TYPE = FLUID_TYPES.register("test_water", () -> new FluidType(FluidType.Properties.create().canSwim(false).canDrown(false).supportsBoating(false).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.FIRE_EXTINGUISH)));
    public static final IClientFluidTypeExtensions GEDRITED_WATER_FLUID = new IClientFluidTypeExtensions(){

        @NotNull
        public ResourceLocation getStillTexture() {
            return GEDRITED_WATER_STILL_RL;
        }

        @NotNull
        public ResourceLocation getFlowingTexture() {
            return GEDRITED_WATER_FLOWING_RL;
        }

        public ResourceLocation getOverlayTexture() {
            return GEDRITED_WATER_OVERLAY_RL;
        }

        public int getTintColor() {
            return -580905;
        }

        @NotNull
        public Vector4f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector4f fluidFogColor) {
            return new Vector4f(0.5294118f, 0.13333334f, 0.4f, 1.0f);
        }

        public void modifyFogRender(Camera camera, @Nullable FogEnvironment environment, float renderDistance, float partialTick, FogData fogData) {
            fogData.renderDistanceStart = -5.0f;
            fogData.renderDistanceEnd = 10.0f;
            fogData.environmentalStart = -5.0f;
            fogData.environmentalEnd = 10.0f;
            fogData.skyEnd = 10.0f;
            fogData.cloudEnd = 10.0f;
        }
    };

    public static void register(IEventBus eventBus) {
        FLUID_TYPES.register(eventBus);
    }

    public static void registerClientItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(GEDRITED_WATER_FLUID, new Holder[]{GEDRITED_WATER_FLUID_TYPE});
    }
}

